/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model.transform;

import com.amazonaws.services.ivs.model.Stream;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class StreamJsonUnmarshaller
implements Unmarshaller<Stream, JsonUnmarshallerContext> {
    private static StreamJsonUnmarshaller instance;

    @Override
    public Stream unmarshall(JsonUnmarshallerContext context) throws Exception {
        Stream stream = new Stream();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("channelArn", targetDepth)) {
                    context.nextToken();
                    stream.setChannelArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("playbackUrl", targetDepth)) {
                    context.nextToken();
                    stream.setPlaybackUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("startTime", targetDepth)) {
                    context.nextToken();
                    stream.setStartTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    stream.setState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("health", targetDepth)) {
                    context.nextToken();
                    stream.setHealth(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("viewerCount", targetDepth)) {
                    context.nextToken();
                    stream.setViewerCount(context.getUnmarshaller(Long.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return stream;
    }

    public static StreamJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StreamJsonUnmarshaller();
        }
        return instance;
    }
}

