/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivs.model.transform.PlaybackKeyPairMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PlaybackKeyPair
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String fingerprint;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public PlaybackKeyPair withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PlaybackKeyPair withName(String name) {
        this.setName(name);
        return this;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public PlaybackKeyPair withFingerprint(String fingerprint) {
        this.setFingerprint(fingerprint);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public PlaybackKeyPair withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public PlaybackKeyPair addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public PlaybackKeyPair clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getFingerprint() != null) {
            sb.append("Fingerprint: ").append(this.getFingerprint()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaybackKeyPair)) {
            return false;
        }
        PlaybackKeyPair other = (PlaybackKeyPair)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFingerprint() == null ^ this.getFingerprint() == null) {
            return false;
        }
        if (other.getFingerprint() != null && !other.getFingerprint().equals(this.getFingerprint())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getFingerprint() == null ? 0 : this.getFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public PlaybackKeyPair clone() {
        try {
            return (PlaybackKeyPair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlaybackKeyPairMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

