/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ivs.AmazonIVSAsync;
import com.amazonaws.services.ivs.AmazonIVSAsyncClientBuilder;
import com.amazonaws.services.ivs.AmazonIVSClient;
import com.amazonaws.services.ivs.model.BatchGetChannelRequest;
import com.amazonaws.services.ivs.model.BatchGetChannelResult;
import com.amazonaws.services.ivs.model.BatchGetStreamKeyRequest;
import com.amazonaws.services.ivs.model.BatchGetStreamKeyResult;
import com.amazonaws.services.ivs.model.CreateChannelRequest;
import com.amazonaws.services.ivs.model.CreateChannelResult;
import com.amazonaws.services.ivs.model.CreateStreamKeyRequest;
import com.amazonaws.services.ivs.model.CreateStreamKeyResult;
import com.amazonaws.services.ivs.model.DeleteChannelRequest;
import com.amazonaws.services.ivs.model.DeleteChannelResult;
import com.amazonaws.services.ivs.model.DeletePlaybackKeyPairRequest;
import com.amazonaws.services.ivs.model.DeletePlaybackKeyPairResult;
import com.amazonaws.services.ivs.model.DeleteStreamKeyRequest;
import com.amazonaws.services.ivs.model.DeleteStreamKeyResult;
import com.amazonaws.services.ivs.model.GetChannelRequest;
import com.amazonaws.services.ivs.model.GetChannelResult;
import com.amazonaws.services.ivs.model.GetPlaybackKeyPairRequest;
import com.amazonaws.services.ivs.model.GetPlaybackKeyPairResult;
import com.amazonaws.services.ivs.model.GetStreamKeyRequest;
import com.amazonaws.services.ivs.model.GetStreamKeyResult;
import com.amazonaws.services.ivs.model.GetStreamRequest;
import com.amazonaws.services.ivs.model.GetStreamResult;
import com.amazonaws.services.ivs.model.ImportPlaybackKeyPairRequest;
import com.amazonaws.services.ivs.model.ImportPlaybackKeyPairResult;
import com.amazonaws.services.ivs.model.ListChannelsRequest;
import com.amazonaws.services.ivs.model.ListChannelsResult;
import com.amazonaws.services.ivs.model.ListPlaybackKeyPairsRequest;
import com.amazonaws.services.ivs.model.ListPlaybackKeyPairsResult;
import com.amazonaws.services.ivs.model.ListStreamKeysRequest;
import com.amazonaws.services.ivs.model.ListStreamKeysResult;
import com.amazonaws.services.ivs.model.ListStreamsRequest;
import com.amazonaws.services.ivs.model.ListStreamsResult;
import com.amazonaws.services.ivs.model.ListTagsForResourceRequest;
import com.amazonaws.services.ivs.model.ListTagsForResourceResult;
import com.amazonaws.services.ivs.model.PutMetadataRequest;
import com.amazonaws.services.ivs.model.PutMetadataResult;
import com.amazonaws.services.ivs.model.StopStreamRequest;
import com.amazonaws.services.ivs.model.StopStreamResult;
import com.amazonaws.services.ivs.model.TagResourceRequest;
import com.amazonaws.services.ivs.model.TagResourceResult;
import com.amazonaws.services.ivs.model.UntagResourceRequest;
import com.amazonaws.services.ivs.model.UntagResourceResult;
import com.amazonaws.services.ivs.model.UpdateChannelRequest;
import com.amazonaws.services.ivs.model.UpdateChannelResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonIVSAsyncClient
extends AmazonIVSClient
implements AmazonIVSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonIVSAsyncClientBuilder asyncBuilder() {
        return AmazonIVSAsyncClientBuilder.standard();
    }

    AmazonIVSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonIVSAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetChannelResult> batchGetChannelAsync(BatchGetChannelRequest request) {
        return this.batchGetChannelAsync(request, null);
    }

    @Override
    public Future<BatchGetChannelResult> batchGetChannelAsync(BatchGetChannelRequest request, final AsyncHandler<BatchGetChannelRequest, BatchGetChannelResult> asyncHandler) {
        final BatchGetChannelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetChannelResult>(){

            @Override
            public BatchGetChannelResult call() throws Exception {
                BatchGetChannelResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeBatchGetChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetStreamKeyResult> batchGetStreamKeyAsync(BatchGetStreamKeyRequest request) {
        return this.batchGetStreamKeyAsync(request, null);
    }

    @Override
    public Future<BatchGetStreamKeyResult> batchGetStreamKeyAsync(BatchGetStreamKeyRequest request, final AsyncHandler<BatchGetStreamKeyRequest, BatchGetStreamKeyResult> asyncHandler) {
        final BatchGetStreamKeyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetStreamKeyResult>(){

            @Override
            public BatchGetStreamKeyResult call() throws Exception {
                BatchGetStreamKeyResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeBatchGetStreamKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelAsync(request, null);
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request, final AsyncHandler<CreateChannelRequest, CreateChannelResult> asyncHandler) {
        final CreateChannelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChannelResult>(){

            @Override
            public CreateChannelResult call() throws Exception {
                CreateChannelResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeCreateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamKeyResult> createStreamKeyAsync(CreateStreamKeyRequest request) {
        return this.createStreamKeyAsync(request, null);
    }

    @Override
    public Future<CreateStreamKeyResult> createStreamKeyAsync(CreateStreamKeyRequest request, final AsyncHandler<CreateStreamKeyRequest, CreateStreamKeyResult> asyncHandler) {
        final CreateStreamKeyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStreamKeyResult>(){

            @Override
            public CreateStreamKeyResult call() throws Exception {
                CreateStreamKeyResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeCreateStreamKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelAsync(request, null);
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request, final AsyncHandler<DeleteChannelRequest, DeleteChannelResult> asyncHandler) {
        final DeleteChannelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelResult>(){

            @Override
            public DeleteChannelResult call() throws Exception {
                DeleteChannelResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeDeleteChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePlaybackKeyPairResult> deletePlaybackKeyPairAsync(DeletePlaybackKeyPairRequest request) {
        return this.deletePlaybackKeyPairAsync(request, null);
    }

    @Override
    public Future<DeletePlaybackKeyPairResult> deletePlaybackKeyPairAsync(DeletePlaybackKeyPairRequest request, final AsyncHandler<DeletePlaybackKeyPairRequest, DeletePlaybackKeyPairResult> asyncHandler) {
        final DeletePlaybackKeyPairRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePlaybackKeyPairResult>(){

            @Override
            public DeletePlaybackKeyPairResult call() throws Exception {
                DeletePlaybackKeyPairResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeDeletePlaybackKeyPair(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStreamKeyResult> deleteStreamKeyAsync(DeleteStreamKeyRequest request) {
        return this.deleteStreamKeyAsync(request, null);
    }

    @Override
    public Future<DeleteStreamKeyResult> deleteStreamKeyAsync(DeleteStreamKeyRequest request, final AsyncHandler<DeleteStreamKeyRequest, DeleteStreamKeyResult> asyncHandler) {
        final DeleteStreamKeyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStreamKeyResult>(){

            @Override
            public DeleteStreamKeyResult call() throws Exception {
                DeleteStreamKeyResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeDeleteStreamKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChannelResult> getChannelAsync(GetChannelRequest request) {
        return this.getChannelAsync(request, null);
    }

    @Override
    public Future<GetChannelResult> getChannelAsync(GetChannelRequest request, final AsyncHandler<GetChannelRequest, GetChannelResult> asyncHandler) {
        final GetChannelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetChannelResult>(){

            @Override
            public GetChannelResult call() throws Exception {
                GetChannelResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeGetChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPlaybackKeyPairResult> getPlaybackKeyPairAsync(GetPlaybackKeyPairRequest request) {
        return this.getPlaybackKeyPairAsync(request, null);
    }

    @Override
    public Future<GetPlaybackKeyPairResult> getPlaybackKeyPairAsync(GetPlaybackKeyPairRequest request, final AsyncHandler<GetPlaybackKeyPairRequest, GetPlaybackKeyPairResult> asyncHandler) {
        final GetPlaybackKeyPairRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPlaybackKeyPairResult>(){

            @Override
            public GetPlaybackKeyPairResult call() throws Exception {
                GetPlaybackKeyPairResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeGetPlaybackKeyPair(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStreamResult> getStreamAsync(GetStreamRequest request) {
        return this.getStreamAsync(request, null);
    }

    @Override
    public Future<GetStreamResult> getStreamAsync(GetStreamRequest request, final AsyncHandler<GetStreamRequest, GetStreamResult> asyncHandler) {
        final GetStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStreamResult>(){

            @Override
            public GetStreamResult call() throws Exception {
                GetStreamResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeGetStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStreamKeyResult> getStreamKeyAsync(GetStreamKeyRequest request) {
        return this.getStreamKeyAsync(request, null);
    }

    @Override
    public Future<GetStreamKeyResult> getStreamKeyAsync(GetStreamKeyRequest request, final AsyncHandler<GetStreamKeyRequest, GetStreamKeyResult> asyncHandler) {
        final GetStreamKeyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStreamKeyResult>(){

            @Override
            public GetStreamKeyResult call() throws Exception {
                GetStreamKeyResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeGetStreamKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportPlaybackKeyPairResult> importPlaybackKeyPairAsync(ImportPlaybackKeyPairRequest request) {
        return this.importPlaybackKeyPairAsync(request, null);
    }

    @Override
    public Future<ImportPlaybackKeyPairResult> importPlaybackKeyPairAsync(ImportPlaybackKeyPairRequest request, final AsyncHandler<ImportPlaybackKeyPairRequest, ImportPlaybackKeyPairResult> asyncHandler) {
        final ImportPlaybackKeyPairRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportPlaybackKeyPairResult>(){

            @Override
            public ImportPlaybackKeyPairResult call() throws Exception {
                ImportPlaybackKeyPairResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeImportPlaybackKeyPair(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request) {
        return this.listChannelsAsync(request, null);
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request, final AsyncHandler<ListChannelsRequest, ListChannelsResult> asyncHandler) {
        final ListChannelsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChannelsResult>(){

            @Override
            public ListChannelsResult call() throws Exception {
                ListChannelsResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeListChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPlaybackKeyPairsResult> listPlaybackKeyPairsAsync(ListPlaybackKeyPairsRequest request) {
        return this.listPlaybackKeyPairsAsync(request, null);
    }

    @Override
    public Future<ListPlaybackKeyPairsResult> listPlaybackKeyPairsAsync(ListPlaybackKeyPairsRequest request, final AsyncHandler<ListPlaybackKeyPairsRequest, ListPlaybackKeyPairsResult> asyncHandler) {
        final ListPlaybackKeyPairsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPlaybackKeyPairsResult>(){

            @Override
            public ListPlaybackKeyPairsResult call() throws Exception {
                ListPlaybackKeyPairsResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeListPlaybackKeyPairs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamKeysResult> listStreamKeysAsync(ListStreamKeysRequest request) {
        return this.listStreamKeysAsync(request, null);
    }

    @Override
    public Future<ListStreamKeysResult> listStreamKeysAsync(ListStreamKeysRequest request, final AsyncHandler<ListStreamKeysRequest, ListStreamKeysResult> asyncHandler) {
        final ListStreamKeysRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStreamKeysResult>(){

            @Override
            public ListStreamKeysResult call() throws Exception {
                ListStreamKeysResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeListStreamKeys(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request) {
        return this.listStreamsAsync(request, null);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request, final AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        final ListStreamsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() throws Exception {
                ListStreamsResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeListStreams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMetadataResult> putMetadataAsync(PutMetadataRequest request) {
        return this.putMetadataAsync(request, null);
    }

    @Override
    public Future<PutMetadataResult> putMetadataAsync(PutMetadataRequest request, final AsyncHandler<PutMetadataRequest, PutMetadataResult> asyncHandler) {
        final PutMetadataRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutMetadataResult>(){

            @Override
            public PutMetadataResult call() throws Exception {
                PutMetadataResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executePutMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopStreamResult> stopStreamAsync(StopStreamRequest request) {
        return this.stopStreamAsync(request, null);
    }

    @Override
    public Future<StopStreamResult> stopStreamAsync(StopStreamRequest request, final AsyncHandler<StopStreamRequest, StopStreamResult> asyncHandler) {
        final StopStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopStreamResult>(){

            @Override
            public StopStreamResult call() throws Exception {
                StopStreamResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeStopStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelAsync(request, null);
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request, final AsyncHandler<UpdateChannelRequest, UpdateChannelResult> asyncHandler) {
        final UpdateChannelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChannelResult>(){

            @Override
            public UpdateChannelResult call() throws Exception {
                UpdateChannelResult result = null;
                try {
                    result = AmazonIVSAsyncClient.this.executeUpdateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

