/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.iotsitewise.AWSIoTSiteWise;
import com.amazonaws.services.iotsitewise.model.DescribeAssetModelRequest;
import com.amazonaws.services.iotsitewise.model.DescribeAssetModelResult;
import com.amazonaws.services.iotsitewise.model.DescribeAssetRequest;
import com.amazonaws.services.iotsitewise.model.DescribeAssetResult;
import com.amazonaws.services.iotsitewise.model.DescribePortalRequest;
import com.amazonaws.services.iotsitewise.model.DescribePortalResult;
import com.amazonaws.services.iotsitewise.waiters.AssetActive;
import com.amazonaws.services.iotsitewise.waiters.AssetModelActive;
import com.amazonaws.services.iotsitewise.waiters.AssetModelNotExists;
import com.amazonaws.services.iotsitewise.waiters.AssetNotExists;
import com.amazonaws.services.iotsitewise.waiters.DescribeAssetFunction;
import com.amazonaws.services.iotsitewise.waiters.DescribeAssetModelFunction;
import com.amazonaws.services.iotsitewise.waiters.DescribePortalFunction;
import com.amazonaws.services.iotsitewise.waiters.PortalActive;
import com.amazonaws.services.iotsitewise.waiters.PortalNotExists;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSIoTSiteWiseWaiters {
    private final AWSIoTSiteWise client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AWSIoTSiteWiseWaiters");

    @SdkInternalApi
    public AWSIoTSiteWiseWaiters(AWSIoTSiteWise client) {
        this.client = client;
    }

    public Waiter<DescribePortalRequest> portalNotExists() {
        return new WaiterBuilder<DescribePortalRequest, DescribePortalResult>().withSdkFunction(new DescribePortalFunction(this.client)).withAcceptors(new PortalNotExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribePortalRequest> portalActive() {
        return new WaiterBuilder<DescribePortalRequest, DescribePortalResult>().withSdkFunction(new DescribePortalFunction(this.client)).withAcceptors(new PortalActive.IsACTIVEMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAssetModelRequest> assetModelActive() {
        return new WaiterBuilder<DescribeAssetModelRequest, DescribeAssetModelResult>().withSdkFunction(new DescribeAssetModelFunction(this.client)).withAcceptors(new AssetModelActive.IsACTIVEMatcher(), new AssetModelActive.IsFAILEDMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAssetRequest> assetNotExists() {
        return new WaiterBuilder<DescribeAssetRequest, DescribeAssetResult>().withSdkFunction(new DescribeAssetFunction(this.client)).withAcceptors(new AssetNotExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAssetModelRequest> assetModelNotExists() {
        return new WaiterBuilder<DescribeAssetModelRequest, DescribeAssetModelResult>().withSdkFunction(new DescribeAssetModelFunction(this.client)).withAcceptors(new AssetModelNotExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAssetRequest> assetActive() {
        return new WaiterBuilder<DescribeAssetRequest, DescribeAssetResult>().withSdkFunction(new DescribeAssetFunction(this.client)).withAcceptors(new AssetActive.IsACTIVEMatcher(), new AssetActive.IsFAILEDMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

