/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.ExpressionVariable;
import com.amazonaws.services.iotsitewise.model.transform.TransformMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Transform
implements Serializable,
Cloneable,
StructuredPojo {
    private String expression;
    private List<ExpressionVariable> variables;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public Transform withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public List<ExpressionVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<ExpressionVariable> variables) {
        if (variables == null) {
            this.variables = null;
            return;
        }
        this.variables = new ArrayList<ExpressionVariable>(variables);
    }

    public Transform withVariables(ExpressionVariable ... variables) {
        if (this.variables == null) {
            this.setVariables(new ArrayList<ExpressionVariable>(variables.length));
        }
        for (ExpressionVariable ele : variables) {
            this.variables.add(ele);
        }
        return this;
    }

    public Transform withVariables(Collection<ExpressionVariable> variables) {
        this.setVariables(variables);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExpression() != null) {
            sb.append("Expression: ").append(this.getExpression()).append(",");
        }
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transform)) {
            return false;
        }
        Transform other = (Transform)obj;
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        if (other.getExpression() != null && !other.getExpression().equals(this.getExpression())) {
            return false;
        }
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        return other.getVariables() == null || other.getVariables().equals(this.getVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        return hashCode;
    }

    public Transform clone() {
        try {
            return (Transform)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransformMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

