/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.ExpressionVariable;
import com.amazonaws.services.iotsitewise.model.MetricWindow;
import com.amazonaws.services.iotsitewise.model.transform.MetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Metric
implements Serializable,
Cloneable,
StructuredPojo {
    private String expression;
    private List<ExpressionVariable> variables;
    private MetricWindow window;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public Metric withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public List<ExpressionVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<ExpressionVariable> variables) {
        if (variables == null) {
            this.variables = null;
            return;
        }
        this.variables = new ArrayList<ExpressionVariable>(variables);
    }

    public Metric withVariables(ExpressionVariable ... variables) {
        if (this.variables == null) {
            this.setVariables(new ArrayList<ExpressionVariable>(variables.length));
        }
        for (ExpressionVariable ele : variables) {
            this.variables.add(ele);
        }
        return this;
    }

    public Metric withVariables(Collection<ExpressionVariable> variables) {
        this.setVariables(variables);
        return this;
    }

    public void setWindow(MetricWindow window) {
        this.window = window;
    }

    public MetricWindow getWindow() {
        return this.window;
    }

    public Metric withWindow(MetricWindow window) {
        this.setWindow(window);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExpression() != null) {
            sb.append("Expression: ").append(this.getExpression()).append(",");
        }
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables()).append(",");
        }
        if (this.getWindow() != null) {
            sb.append("Window: ").append(this.getWindow());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)obj;
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        if (other.getExpression() != null && !other.getExpression().equals(this.getExpression())) {
            return false;
        }
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        if (other.getVariables() != null && !other.getVariables().equals(this.getVariables())) {
            return false;
        }
        if (other.getWindow() == null ^ this.getWindow() == null) {
            return false;
        }
        return other.getWindow() == null || other.getWindow().equals(this.getWindow());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        hashCode = 31 * hashCode + (this.getWindow() == null ? 0 : this.getWindow().hashCode());
        return hashCode;
    }

    public Metric clone() {
        try {
            return (Metric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

