/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.BatchPutAssetPropertyValueErrorCode;
import com.amazonaws.services.iotsitewise.model.TimeInNanos;
import com.amazonaws.services.iotsitewise.model.transform.BatchPutAssetPropertyErrorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchPutAssetPropertyError
implements Serializable,
Cloneable,
StructuredPojo {
    private String errorCode;
    private String errorMessage;
    private List<TimeInNanos> timestamps;

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public BatchPutAssetPropertyError withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public BatchPutAssetPropertyError withErrorCode(BatchPutAssetPropertyValueErrorCode errorCode) {
        this.errorCode = errorCode.toString();
        return this;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public BatchPutAssetPropertyError withErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        return this;
    }

    public List<TimeInNanos> getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(Collection<TimeInNanos> timestamps) {
        if (timestamps == null) {
            this.timestamps = null;
            return;
        }
        this.timestamps = new ArrayList<TimeInNanos>(timestamps);
    }

    public BatchPutAssetPropertyError withTimestamps(TimeInNanos ... timestamps) {
        if (this.timestamps == null) {
            this.setTimestamps(new ArrayList<TimeInNanos>(timestamps.length));
        }
        for (TimeInNanos ele : timestamps) {
            this.timestamps.add(ele);
        }
        return this;
    }

    public BatchPutAssetPropertyError withTimestamps(Collection<TimeInNanos> timestamps) {
        this.setTimestamps(timestamps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getErrorCode() != null) {
            sb.append("ErrorCode: ").append(this.getErrorCode()).append(",");
        }
        if (this.getErrorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.getErrorMessage()).append(",");
        }
        if (this.getTimestamps() != null) {
            sb.append("Timestamps: ").append(this.getTimestamps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutAssetPropertyError)) {
            return false;
        }
        BatchPutAssetPropertyError other = (BatchPutAssetPropertyError)obj;
        if (other.getErrorCode() == null ^ this.getErrorCode() == null) {
            return false;
        }
        if (other.getErrorCode() != null && !other.getErrorCode().equals(this.getErrorCode())) {
            return false;
        }
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null) {
            return false;
        }
        if (other.getErrorMessage() != null && !other.getErrorMessage().equals(this.getErrorMessage())) {
            return false;
        }
        if (other.getTimestamps() == null ^ this.getTimestamps() == null) {
            return false;
        }
        return other.getTimestamps() == null || other.getTimestamps().equals(this.getTimestamps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getErrorCode() == null ? 0 : this.getErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamps() == null ? 0 : this.getTimestamps().hashCode());
        return hashCode;
    }

    public BatchPutAssetPropertyError clone() {
        try {
            return (BatchPutAssetPropertyError)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchPutAssetPropertyErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

