/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsecuretunneling.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsecuretunneling.model.transform.DestinationConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DestinationConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String thingName;
    private List<String> services;

    public void setThingName(String thingName) {
        this.thingName = thingName;
    }

    public String getThingName() {
        return this.thingName;
    }

    public DestinationConfig withThingName(String thingName) {
        this.setThingName(thingName);
        return this;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(Collection<String> services) {
        if (services == null) {
            this.services = null;
            return;
        }
        this.services = new ArrayList<String>(services);
    }

    public DestinationConfig withServices(String ... services) {
        if (this.services == null) {
            this.setServices(new ArrayList<String>(services.length));
        }
        for (String ele : services) {
            this.services.add(ele);
        }
        return this;
    }

    public DestinationConfig withServices(Collection<String> services) {
        this.setServices(services);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getThingName() != null) {
            sb.append("ThingName: ").append(this.getThingName()).append(",");
        }
        if (this.getServices() != null) {
            sb.append("Services: ").append(this.getServices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfig)) {
            return false;
        }
        DestinationConfig other = (DestinationConfig)obj;
        if (other.getThingName() == null ^ this.getThingName() == null) {
            return false;
        }
        if (other.getThingName() != null && !other.getThingName().equals(this.getThingName())) {
            return false;
        }
        if (other.getServices() == null ^ this.getServices() == null) {
            return false;
        }
        return other.getServices() == null || other.getServices().equals(this.getServices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getThingName() == null ? 0 : this.getThingName().hashCode());
        hashCode = 31 * hashCode + (this.getServices() == null ? 0 : this.getServices().hashCode());
        return hashCode;
    }

    public DestinationConfig clone() {
        try {
            return (DestinationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

