/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import com.amazonaws.services.imagebuilder.model.S3Logs;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3LogsJsonUnmarshaller
implements Unmarshaller<S3Logs, JsonUnmarshallerContext> {
    private static S3LogsJsonUnmarshaller instance;

    @Override
    public S3Logs unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Logs s3Logs = new S3Logs();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("s3BucketName", targetDepth)) {
                    context.nextToken();
                    s3Logs.setS3BucketName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("s3KeyPrefix", targetDepth)) {
                    context.nextToken();
                    s3Logs.setS3KeyPrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Logs;
    }

    public static S3LogsJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3LogsJsonUnmarshaller();
        }
        return instance;
    }
}

