/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.ComponentType;
import com.amazonaws.services.imagebuilder.model.Platform;
import com.amazonaws.services.imagebuilder.model.transform.ComponentVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String version;
    private String description;
    private String platform;
    private List<String> supportedOsVersions;
    private String type;
    private String owner;
    private String dateCreated;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ComponentVersion withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ComponentVersion withName(String name) {
        this.setName(name);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public ComponentVersion withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ComponentVersion withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public ComponentVersion withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public ComponentVersion withPlatform(Platform platform) {
        this.platform = platform.toString();
        return this;
    }

    public List<String> getSupportedOsVersions() {
        return this.supportedOsVersions;
    }

    public void setSupportedOsVersions(Collection<String> supportedOsVersions) {
        if (supportedOsVersions == null) {
            this.supportedOsVersions = null;
            return;
        }
        this.supportedOsVersions = new ArrayList<String>(supportedOsVersions);
    }

    public ComponentVersion withSupportedOsVersions(String ... supportedOsVersions) {
        if (this.supportedOsVersions == null) {
            this.setSupportedOsVersions(new ArrayList<String>(supportedOsVersions.length));
        }
        for (String ele : supportedOsVersions) {
            this.supportedOsVersions.add(ele);
        }
        return this;
    }

    public ComponentVersion withSupportedOsVersions(Collection<String> supportedOsVersions) {
        this.setSupportedOsVersions(supportedOsVersions);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ComponentVersion withType(String type) {
        this.setType(type);
        return this;
    }

    public ComponentVersion withType(ComponentType type) {
        this.type = type.toString();
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public ComponentVersion withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public ComponentVersion withDateCreated(String dateCreated) {
        this.setDateCreated(dateCreated);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getSupportedOsVersions() != null) {
            sb.append("SupportedOsVersions: ").append(this.getSupportedOsVersions()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getDateCreated() != null) {
            sb.append("DateCreated: ").append(this.getDateCreated());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentVersion)) {
            return false;
        }
        ComponentVersion other = (ComponentVersion)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getSupportedOsVersions() == null ^ this.getSupportedOsVersions() == null) {
            return false;
        }
        if (other.getSupportedOsVersions() != null && !other.getSupportedOsVersions().equals(this.getSupportedOsVersions())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getDateCreated() == null ^ this.getDateCreated() == null) {
            return false;
        }
        return other.getDateCreated() == null || other.getDateCreated().equals(this.getDateCreated());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedOsVersions() == null ? 0 : this.getSupportedOsVersions().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getDateCreated() == null ? 0 : this.getDateCreated().hashCode());
        return hashCode;
    }

    public ComponentVersion clone() {
        try {
            return (ComponentVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

