/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.LaunchPermissionConfiguration;
import com.amazonaws.services.imagebuilder.model.transform.AmiDistributionConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmiDistributionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private List<String> targetAccountIds;
    private Map<String, String> amiTags;
    private String kmsKeyId;
    private LaunchPermissionConfiguration launchPermission;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AmiDistributionConfiguration withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public AmiDistributionConfiguration withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getTargetAccountIds() {
        return this.targetAccountIds;
    }

    public void setTargetAccountIds(Collection<String> targetAccountIds) {
        if (targetAccountIds == null) {
            this.targetAccountIds = null;
            return;
        }
        this.targetAccountIds = new ArrayList<String>(targetAccountIds);
    }

    public AmiDistributionConfiguration withTargetAccountIds(String ... targetAccountIds) {
        if (this.targetAccountIds == null) {
            this.setTargetAccountIds(new ArrayList<String>(targetAccountIds.length));
        }
        for (String ele : targetAccountIds) {
            this.targetAccountIds.add(ele);
        }
        return this;
    }

    public AmiDistributionConfiguration withTargetAccountIds(Collection<String> targetAccountIds) {
        this.setTargetAccountIds(targetAccountIds);
        return this;
    }

    public Map<String, String> getAmiTags() {
        return this.amiTags;
    }

    public void setAmiTags(Map<String, String> amiTags) {
        this.amiTags = amiTags;
    }

    public AmiDistributionConfiguration withAmiTags(Map<String, String> amiTags) {
        this.setAmiTags(amiTags);
        return this;
    }

    public AmiDistributionConfiguration addAmiTagsEntry(String key, String value) {
        if (null == this.amiTags) {
            this.amiTags = new HashMap<String, String>();
        }
        if (this.amiTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.amiTags.put(key, value);
        return this;
    }

    public AmiDistributionConfiguration clearAmiTagsEntries() {
        this.amiTags = null;
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public AmiDistributionConfiguration withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setLaunchPermission(LaunchPermissionConfiguration launchPermission) {
        this.launchPermission = launchPermission;
    }

    public LaunchPermissionConfiguration getLaunchPermission() {
        return this.launchPermission;
    }

    public AmiDistributionConfiguration withLaunchPermission(LaunchPermissionConfiguration launchPermission) {
        this.setLaunchPermission(launchPermission);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTargetAccountIds() != null) {
            sb.append("TargetAccountIds: ").append(this.getTargetAccountIds()).append(",");
        }
        if (this.getAmiTags() != null) {
            sb.append("AmiTags: ").append(this.getAmiTags()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getLaunchPermission() != null) {
            sb.append("LaunchPermission: ").append(this.getLaunchPermission());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiDistributionConfiguration)) {
            return false;
        }
        AmiDistributionConfiguration other = (AmiDistributionConfiguration)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTargetAccountIds() == null ^ this.getTargetAccountIds() == null) {
            return false;
        }
        if (other.getTargetAccountIds() != null && !other.getTargetAccountIds().equals(this.getTargetAccountIds())) {
            return false;
        }
        if (other.getAmiTags() == null ^ this.getAmiTags() == null) {
            return false;
        }
        if (other.getAmiTags() != null && !other.getAmiTags().equals(this.getAmiTags())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getLaunchPermission() == null ^ this.getLaunchPermission() == null) {
            return false;
        }
        return other.getLaunchPermission() == null || other.getLaunchPermission().equals(this.getLaunchPermission());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTargetAccountIds() == null ? 0 : this.getTargetAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getAmiTags() == null ? 0 : this.getAmiTags().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchPermission() == null ? 0 : this.getLaunchPermission().hashCode());
        return hashCode;
    }

    public AmiDistributionConfiguration clone() {
        try {
            return (AmiDistributionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AmiDistributionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

