/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitystore;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.identitystore.AWSIdentityStoreAsync;
import com.amazonaws.services.identitystore.AWSIdentityStoreAsyncClientBuilder;
import com.amazonaws.services.identitystore.AWSIdentityStoreClient;
import com.amazonaws.services.identitystore.model.DescribeGroupRequest;
import com.amazonaws.services.identitystore.model.DescribeGroupResult;
import com.amazonaws.services.identitystore.model.DescribeUserRequest;
import com.amazonaws.services.identitystore.model.DescribeUserResult;
import com.amazonaws.services.identitystore.model.ListGroupsRequest;
import com.amazonaws.services.identitystore.model.ListGroupsResult;
import com.amazonaws.services.identitystore.model.ListUsersRequest;
import com.amazonaws.services.identitystore.model.ListUsersResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIdentityStoreAsyncClient
extends AWSIdentityStoreClient
implements AWSIdentityStoreAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIdentityStoreAsyncClientBuilder asyncBuilder() {
        return AWSIdentityStoreAsyncClientBuilder.standard();
    }

    AWSIdentityStoreAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSIdentityStoreAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeGroupResult> describeGroupAsync(DescribeGroupRequest request) {
        return this.describeGroupAsync(request, null);
    }

    @Override
    public Future<DescribeGroupResult> describeGroupAsync(DescribeGroupRequest request, final AsyncHandler<DescribeGroupRequest, DescribeGroupResult> asyncHandler) {
        final DescribeGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGroupResult>(){

            @Override
            public DescribeGroupResult call() throws Exception {
                DescribeGroupResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeDescribeGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request) {
        return this.describeUserAsync(request, null);
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request, final AsyncHandler<DescribeUserRequest, DescribeUserResult> asyncHandler) {
        final DescribeUserRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUserResult>(){

            @Override
            public DescribeUserResult call() throws Exception {
                DescribeUserResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeDescribeUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request) {
        return this.listGroupsAsync(request, null);
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request, final AsyncHandler<ListGroupsRequest, ListGroupsResult> asyncHandler) {
        final ListGroupsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupsResult>(){

            @Override
            public ListGroupsResult call() throws Exception {
                ListGroupsResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeListGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        final ListUsersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result = null;
                try {
                    result = AWSIdentityStoreAsyncClient.this.executeListUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

