/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.honeycode.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.honeycode.model.ColumnMetadata;
import com.amazonaws.services.honeycode.model.ResultRow;
import com.amazonaws.services.honeycode.model.transform.ResultSetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResultSet
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ColumnMetadata> headers;
    private List<ResultRow> rows;

    public List<ColumnMetadata> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Collection<ColumnMetadata> headers) {
        if (headers == null) {
            this.headers = null;
            return;
        }
        this.headers = new ArrayList<ColumnMetadata>(headers);
    }

    public ResultSet withHeaders(ColumnMetadata ... headers) {
        if (this.headers == null) {
            this.setHeaders(new ArrayList<ColumnMetadata>(headers.length));
        }
        for (ColumnMetadata ele : headers) {
            this.headers.add(ele);
        }
        return this;
    }

    public ResultSet withHeaders(Collection<ColumnMetadata> headers) {
        this.setHeaders(headers);
        return this;
    }

    public List<ResultRow> getRows() {
        return this.rows;
    }

    public void setRows(Collection<ResultRow> rows) {
        if (rows == null) {
            this.rows = null;
            return;
        }
        this.rows = new ArrayList<ResultRow>(rows);
    }

    public ResultSet withRows(ResultRow ... rows) {
        if (this.rows == null) {
            this.setRows(new ArrayList<ResultRow>(rows.length));
        }
        for (ResultRow ele : rows) {
            this.rows.add(ele);
        }
        return this;
    }

    public ResultSet withRows(Collection<ResultRow> rows) {
        this.setRows(rows);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHeaders() != null) {
            sb.append("Headers: ").append(this.getHeaders()).append(",");
        }
        if (this.getRows() != null) {
            sb.append("Rows: ").append(this.getRows());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet)obj;
        if (other.getHeaders() == null ^ this.getHeaders() == null) {
            return false;
        }
        if (other.getHeaders() != null && !other.getHeaders().equals(this.getHeaders())) {
            return false;
        }
        if (other.getRows() == null ^ this.getRows() == null) {
            return false;
        }
        return other.getRows() == null || other.getRows().equals(this.getRows());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHeaders() == null ? 0 : this.getHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getRows() == null ? 0 : this.getRows().hashCode());
        return hashCode;
    }

    public ResultSet clone() {
        try {
            return (ResultSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

