/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.honeycode;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.honeycode.AmazonHoneycodeAsync;
import com.amazonaws.services.honeycode.AmazonHoneycodeAsyncClientBuilder;
import com.amazonaws.services.honeycode.AmazonHoneycodeClient;
import com.amazonaws.services.honeycode.model.GetScreenDataRequest;
import com.amazonaws.services.honeycode.model.GetScreenDataResult;
import com.amazonaws.services.honeycode.model.InvokeScreenAutomationRequest;
import com.amazonaws.services.honeycode.model.InvokeScreenAutomationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonHoneycodeAsyncClient
extends AmazonHoneycodeClient
implements AmazonHoneycodeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonHoneycodeAsyncClientBuilder asyncBuilder() {
        return AmazonHoneycodeAsyncClientBuilder.standard();
    }

    AmazonHoneycodeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonHoneycodeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetScreenDataResult> getScreenDataAsync(GetScreenDataRequest request) {
        return this.getScreenDataAsync(request, null);
    }

    @Override
    public Future<GetScreenDataResult> getScreenDataAsync(GetScreenDataRequest request, final AsyncHandler<GetScreenDataRequest, GetScreenDataResult> asyncHandler) {
        final GetScreenDataRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetScreenDataResult>(){

            @Override
            public GetScreenDataResult call() throws Exception {
                GetScreenDataResult result = null;
                try {
                    result = AmazonHoneycodeAsyncClient.this.executeGetScreenData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InvokeScreenAutomationResult> invokeScreenAutomationAsync(InvokeScreenAutomationRequest request) {
        return this.invokeScreenAutomationAsync(request, null);
    }

    @Override
    public Future<InvokeScreenAutomationResult> invokeScreenAutomationAsync(InvokeScreenAutomationRequest request, final AsyncHandler<InvokeScreenAutomationRequest, InvokeScreenAutomationResult> asyncHandler) {
        final InvokeScreenAutomationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InvokeScreenAutomationResult>(){

            @Override
            public InvokeScreenAutomationResult call() throws Exception {
                InvokeScreenAutomationResult result = null;
                try {
                    result = AmazonHoneycodeAsyncClient.this.executeInvokeScreenAutomation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

