/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.KMSKey;

@SdkInternalApi
public class KMSKeyMarshaller {
    private static final MarshallingInfo<String> KMSENCRYPTIONKEYARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsEncryptionKeyArn").build();
    private static final KMSKeyMarshaller instance = new KMSKeyMarshaller();

    public static KMSKeyMarshaller getInstance() {
        return instance;
    }

    public void marshall(KMSKey kMSKey, ProtocolMarshaller protocolMarshaller) {
        if (kMSKey == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(kMSKey.getKmsEncryptionKeyArn(), KMSENCRYPTIONKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

