/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.frauddetector.model.Language;
import com.amazonaws.services.frauddetector.model.Rule;
import com.amazonaws.services.frauddetector.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRuleVersionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Rule rule;
    private String description;
    private String expression;
    private String language;
    private List<String> outcomes;
    private List<Tag> tags;

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public Rule getRule() {
        return this.rule;
    }

    public UpdateRuleVersionRequest withRule(Rule rule) {
        this.setRule(rule);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateRuleVersionRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public UpdateRuleVersionRequest withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public UpdateRuleVersionRequest withLanguage(String language) {
        this.setLanguage(language);
        return this;
    }

    public UpdateRuleVersionRequest withLanguage(Language language) {
        this.language = language.toString();
        return this;
    }

    public List<String> getOutcomes() {
        return this.outcomes;
    }

    public void setOutcomes(Collection<String> outcomes) {
        if (outcomes == null) {
            this.outcomes = null;
            return;
        }
        this.outcomes = new ArrayList<String>(outcomes);
    }

    public UpdateRuleVersionRequest withOutcomes(String ... outcomes) {
        if (this.outcomes == null) {
            this.setOutcomes(new ArrayList<String>(outcomes.length));
        }
        for (String ele : outcomes) {
            this.outcomes.add(ele);
        }
        return this;
    }

    public UpdateRuleVersionRequest withOutcomes(Collection<String> outcomes) {
        this.setOutcomes(outcomes);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public UpdateRuleVersionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public UpdateRuleVersionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRule() != null) {
            sb.append("Rule: ").append(this.getRule()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getExpression() != null) {
            sb.append("Expression: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getLanguage() != null) {
            sb.append("Language: ").append(this.getLanguage()).append(",");
        }
        if (this.getOutcomes() != null) {
            sb.append("Outcomes: ").append(this.getOutcomes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleVersionRequest)) {
            return false;
        }
        UpdateRuleVersionRequest other = (UpdateRuleVersionRequest)obj;
        if (other.getRule() == null ^ this.getRule() == null) {
            return false;
        }
        if (other.getRule() != null && !other.getRule().equals(this.getRule())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        if (other.getExpression() != null && !other.getExpression().equals(this.getExpression())) {
            return false;
        }
        if (other.getLanguage() == null ^ this.getLanguage() == null) {
            return false;
        }
        if (other.getLanguage() != null && !other.getLanguage().equals(this.getLanguage())) {
            return false;
        }
        if (other.getOutcomes() == null ^ this.getOutcomes() == null) {
            return false;
        }
        if (other.getOutcomes() != null && !other.getOutcomes().equals(this.getOutcomes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRule() == null ? 0 : this.getRule().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        hashCode = 31 * hashCode + (this.getLanguage() == null ? 0 : this.getLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getOutcomes() == null ? 0 : this.getOutcomes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public UpdateRuleVersionRequest clone() {
        return (UpdateRuleVersionRequest)super.clone();
    }
}

