/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.MetricDataPoint;
import com.amazonaws.services.frauddetector.model.transform.TrainingMetricsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TrainingMetrics
implements Serializable,
Cloneable,
StructuredPojo {
    private Float auc;
    private List<MetricDataPoint> metricDataPoints;

    public void setAuc(Float auc) {
        this.auc = auc;
    }

    public Float getAuc() {
        return this.auc;
    }

    public TrainingMetrics withAuc(Float auc) {
        this.setAuc(auc);
        return this;
    }

    public List<MetricDataPoint> getMetricDataPoints() {
        return this.metricDataPoints;
    }

    public void setMetricDataPoints(Collection<MetricDataPoint> metricDataPoints) {
        if (metricDataPoints == null) {
            this.metricDataPoints = null;
            return;
        }
        this.metricDataPoints = new ArrayList<MetricDataPoint>(metricDataPoints);
    }

    public TrainingMetrics withMetricDataPoints(MetricDataPoint ... metricDataPoints) {
        if (this.metricDataPoints == null) {
            this.setMetricDataPoints(new ArrayList<MetricDataPoint>(metricDataPoints.length));
        }
        for (MetricDataPoint ele : metricDataPoints) {
            this.metricDataPoints.add(ele);
        }
        return this;
    }

    public TrainingMetrics withMetricDataPoints(Collection<MetricDataPoint> metricDataPoints) {
        this.setMetricDataPoints(metricDataPoints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuc() != null) {
            sb.append("Auc: ").append(this.getAuc()).append(",");
        }
        if (this.getMetricDataPoints() != null) {
            sb.append("MetricDataPoints: ").append(this.getMetricDataPoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingMetrics)) {
            return false;
        }
        TrainingMetrics other = (TrainingMetrics)obj;
        if (other.getAuc() == null ^ this.getAuc() == null) {
            return false;
        }
        if (other.getAuc() != null && !other.getAuc().equals(this.getAuc())) {
            return false;
        }
        if (other.getMetricDataPoints() == null ^ this.getMetricDataPoints() == null) {
            return false;
        }
        return other.getMetricDataPoints() == null || other.getMetricDataPoints().equals(this.getMetricDataPoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuc() == null ? 0 : this.getAuc().hashCode());
        hashCode = 31 * hashCode + (this.getMetricDataPoints() == null ? 0 : this.getMetricDataPoints().hashCode());
        return hashCode;
    }

    public TrainingMetrics clone() {
        try {
            return (TrainingMetrics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrainingMetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

