/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.frauddetector.AmazonFraudDetector;
import com.amazonaws.services.frauddetector.AmazonFraudDetectorClientBuilder;
import com.amazonaws.services.frauddetector.model.AmazonFraudDetectorException;
import com.amazonaws.services.frauddetector.model.BatchCreateVariableRequest;
import com.amazonaws.services.frauddetector.model.BatchCreateVariableResult;
import com.amazonaws.services.frauddetector.model.BatchGetVariableRequest;
import com.amazonaws.services.frauddetector.model.BatchGetVariableResult;
import com.amazonaws.services.frauddetector.model.CreateDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.CreateDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.CreateModelRequest;
import com.amazonaws.services.frauddetector.model.CreateModelResult;
import com.amazonaws.services.frauddetector.model.CreateModelVersionRequest;
import com.amazonaws.services.frauddetector.model.CreateModelVersionResult;
import com.amazonaws.services.frauddetector.model.CreateRuleRequest;
import com.amazonaws.services.frauddetector.model.CreateRuleResult;
import com.amazonaws.services.frauddetector.model.CreateVariableRequest;
import com.amazonaws.services.frauddetector.model.CreateVariableResult;
import com.amazonaws.services.frauddetector.model.DeleteDetectorRequest;
import com.amazonaws.services.frauddetector.model.DeleteDetectorResult;
import com.amazonaws.services.frauddetector.model.DeleteDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.DeleteDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.DeleteEventRequest;
import com.amazonaws.services.frauddetector.model.DeleteEventResult;
import com.amazonaws.services.frauddetector.model.DeleteRuleRequest;
import com.amazonaws.services.frauddetector.model.DeleteRuleResult;
import com.amazonaws.services.frauddetector.model.DescribeDetectorRequest;
import com.amazonaws.services.frauddetector.model.DescribeDetectorResult;
import com.amazonaws.services.frauddetector.model.DescribeModelVersionsRequest;
import com.amazonaws.services.frauddetector.model.DescribeModelVersionsResult;
import com.amazonaws.services.frauddetector.model.GetDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.GetDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.GetDetectorsRequest;
import com.amazonaws.services.frauddetector.model.GetDetectorsResult;
import com.amazonaws.services.frauddetector.model.GetEntityTypesRequest;
import com.amazonaws.services.frauddetector.model.GetEntityTypesResult;
import com.amazonaws.services.frauddetector.model.GetEventPredictionRequest;
import com.amazonaws.services.frauddetector.model.GetEventPredictionResult;
import com.amazonaws.services.frauddetector.model.GetEventTypesRequest;
import com.amazonaws.services.frauddetector.model.GetEventTypesResult;
import com.amazonaws.services.frauddetector.model.GetExternalModelsRequest;
import com.amazonaws.services.frauddetector.model.GetExternalModelsResult;
import com.amazonaws.services.frauddetector.model.GetKMSEncryptionKeyRequest;
import com.amazonaws.services.frauddetector.model.GetKMSEncryptionKeyResult;
import com.amazonaws.services.frauddetector.model.GetLabelsRequest;
import com.amazonaws.services.frauddetector.model.GetLabelsResult;
import com.amazonaws.services.frauddetector.model.GetModelVersionRequest;
import com.amazonaws.services.frauddetector.model.GetModelVersionResult;
import com.amazonaws.services.frauddetector.model.GetModelsRequest;
import com.amazonaws.services.frauddetector.model.GetModelsResult;
import com.amazonaws.services.frauddetector.model.GetOutcomesRequest;
import com.amazonaws.services.frauddetector.model.GetOutcomesResult;
import com.amazonaws.services.frauddetector.model.GetRulesRequest;
import com.amazonaws.services.frauddetector.model.GetRulesResult;
import com.amazonaws.services.frauddetector.model.GetVariablesRequest;
import com.amazonaws.services.frauddetector.model.GetVariablesResult;
import com.amazonaws.services.frauddetector.model.ListTagsForResourceRequest;
import com.amazonaws.services.frauddetector.model.ListTagsForResourceResult;
import com.amazonaws.services.frauddetector.model.PutDetectorRequest;
import com.amazonaws.services.frauddetector.model.PutDetectorResult;
import com.amazonaws.services.frauddetector.model.PutEntityTypeRequest;
import com.amazonaws.services.frauddetector.model.PutEntityTypeResult;
import com.amazonaws.services.frauddetector.model.PutEventTypeRequest;
import com.amazonaws.services.frauddetector.model.PutEventTypeResult;
import com.amazonaws.services.frauddetector.model.PutExternalModelRequest;
import com.amazonaws.services.frauddetector.model.PutExternalModelResult;
import com.amazonaws.services.frauddetector.model.PutKMSEncryptionKeyRequest;
import com.amazonaws.services.frauddetector.model.PutKMSEncryptionKeyResult;
import com.amazonaws.services.frauddetector.model.PutLabelRequest;
import com.amazonaws.services.frauddetector.model.PutLabelResult;
import com.amazonaws.services.frauddetector.model.PutOutcomeRequest;
import com.amazonaws.services.frauddetector.model.PutOutcomeResult;
import com.amazonaws.services.frauddetector.model.TagResourceRequest;
import com.amazonaws.services.frauddetector.model.TagResourceResult;
import com.amazonaws.services.frauddetector.model.UntagResourceRequest;
import com.amazonaws.services.frauddetector.model.UntagResourceResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionMetadataResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionStatusResult;
import com.amazonaws.services.frauddetector.model.UpdateModelRequest;
import com.amazonaws.services.frauddetector.model.UpdateModelResult;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionStatusRequest;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionStatusResult;
import com.amazonaws.services.frauddetector.model.UpdateRuleMetadataRequest;
import com.amazonaws.services.frauddetector.model.UpdateRuleMetadataResult;
import com.amazonaws.services.frauddetector.model.UpdateRuleVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateRuleVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateVariableRequest;
import com.amazonaws.services.frauddetector.model.UpdateVariableResult;
import com.amazonaws.services.frauddetector.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.BatchCreateVariableRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.BatchCreateVariableResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.BatchGetVariableRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.BatchGetVariableResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateDetectorVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateDetectorVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateModelRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateModelResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateModelVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateModelVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateRuleRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateRuleResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateVariableRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateVariableResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteDetectorRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteDetectorResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteDetectorVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteDetectorVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteEventRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteEventResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteRuleRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteRuleResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DescribeDetectorRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DescribeDetectorResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DescribeModelVersionsRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DescribeModelVersionsResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetDetectorVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetDetectorVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetDetectorsRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetDetectorsResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetEntityTypesRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetEntityTypesResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetEventPredictionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetEventPredictionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetEventTypesRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetEventTypesResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetExternalModelsRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetExternalModelsResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetKMSEncryptionKeyRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetKMSEncryptionKeyResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetLabelsRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetLabelsResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetModelVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetModelVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetModelsRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetModelsResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetOutcomesRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetOutcomesResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetRulesRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetRulesResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetVariablesRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetVariablesResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutDetectorRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutDetectorResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutEntityTypeRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutEntityTypeResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutEventTypeRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutEventTypeResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutExternalModelRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutExternalModelResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutKMSEncryptionKeyRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutKMSEncryptionKeyResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutLabelRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutLabelResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutOutcomeRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutOutcomeResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionMetadataRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionMetadataResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionStatusRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionStatusResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateModelRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateModelResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateModelVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateModelVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateModelVersionStatusRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateModelVersionStatusResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateRuleMetadataRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateRuleMetadataResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateRuleVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateRuleVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateVariableRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateVariableResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonFraudDetectorClient
extends AmazonWebServiceClient
implements AmazonFraudDetector {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonFraudDetector.class);
    private static final String DEFAULT_SIGNING_NAME = "frauddetector";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller(ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller(AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonFraudDetectorException.class));

    public static AmazonFraudDetectorClientBuilder builder() {
        return AmazonFraudDetectorClientBuilder.standard();
    }

    AmazonFraudDetectorClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonFraudDetectorClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("frauddetector.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/frauddetector/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/frauddetector/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchCreateVariableResult batchCreateVariable(BatchCreateVariableRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchCreateVariable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchCreateVariableResult executeBatchCreateVariable(BatchCreateVariableRequest batchCreateVariableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchCreateVariableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchCreateVariableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchCreateVariableRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchCreateVariableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "BatchCreateVariable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchCreateVariableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchCreateVariableResult batchCreateVariableResult = (BatchCreateVariableResult)response.getAwsResponse();
            return batchCreateVariableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetVariableResult batchGetVariable(BatchGetVariableRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchGetVariable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetVariableResult executeBatchGetVariable(BatchGetVariableRequest batchGetVariableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetVariableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetVariableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetVariableRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchGetVariableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "BatchGetVariable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchGetVariableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetVariableResult batchGetVariableResult = (BatchGetVariableResult)response.getAwsResponse();
            return batchGetVariableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDetectorVersionResult createDetectorVersion(CreateDetectorVersionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateDetectorVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDetectorVersionResult executeCreateDetectorVersion(CreateDetectorVersionRequest createDetectorVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDetectorVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDetectorVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDetectorVersionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createDetectorVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateDetectorVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateDetectorVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDetectorVersionResult createDetectorVersionResult = (CreateDetectorVersionResult)response.getAwsResponse();
            return createDetectorVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateModelResult createModel(CreateModelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateModelResult executeCreateModel(CreateModelRequest createModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateModelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateModelResult createModelResult = (CreateModelResult)response.getAwsResponse();
            return createModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateModelVersionResult createModelVersion(CreateModelVersionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateModelVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateModelVersionResult executeCreateModelVersion(CreateModelVersionRequest createModelVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createModelVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateModelVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateModelVersionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createModelVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateModelVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateModelVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateModelVersionResult createModelVersionResult = (CreateModelVersionResult)response.getAwsResponse();
            return createModelVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRuleResult createRule(CreateRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRuleResult executeCreateRule(CreateRuleRequest createRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRuleResult createRuleResult = (CreateRuleResult)response.getAwsResponse();
            return createRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateVariableResult createVariable(CreateVariableRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateVariable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateVariableResult executeCreateVariable(CreateVariableRequest createVariableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createVariableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVariableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVariableRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createVariableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateVariable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateVariableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateVariableResult createVariableResult = (CreateVariableResult)response.getAwsResponse();
            return createVariableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDetectorResult deleteDetector(DeleteDetectorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteDetector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDetectorResult executeDeleteDetector(DeleteDetectorRequest deleteDetectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDetectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDetectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDetectorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteDetectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteDetector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteDetectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDetectorResult deleteDetectorResult = (DeleteDetectorResult)response.getAwsResponse();
            return deleteDetectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDetectorVersionResult deleteDetectorVersion(DeleteDetectorVersionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteDetectorVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDetectorVersionResult executeDeleteDetectorVersion(DeleteDetectorVersionRequest deleteDetectorVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDetectorVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDetectorVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDetectorVersionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteDetectorVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteDetectorVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteDetectorVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDetectorVersionResult deleteDetectorVersionResult = (DeleteDetectorVersionResult)response.getAwsResponse();
            return deleteDetectorVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEventResult deleteEvent(DeleteEventRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteEvent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEventResult executeDeleteEvent(DeleteEventRequest deleteEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEventRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteEvent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteEventResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEventResult deleteEventResult = (DeleteEventResult)response.getAwsResponse();
            return deleteEventResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRuleResult deleteRule(DeleteRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRuleResult executeDeleteRule(DeleteRuleRequest deleteRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRuleResult deleteRuleResult = (DeleteRuleResult)response.getAwsResponse();
            return deleteRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDetectorResult describeDetector(DescribeDetectorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeDetector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDetectorResult executeDescribeDetector(DescribeDetectorRequest describeDetectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDetectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDetectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDetectorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeDetectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeDetector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeDetectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDetectorResult describeDetectorResult = (DescribeDetectorResult)response.getAwsResponse();
            return describeDetectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeModelVersionsResult describeModelVersions(DescribeModelVersionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeModelVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeModelVersionsResult executeDescribeModelVersions(DescribeModelVersionsRequest describeModelVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeModelVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeModelVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeModelVersionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeModelVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeModelVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeModelVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeModelVersionsResult describeModelVersionsResult = (DescribeModelVersionsResult)response.getAwsResponse();
            return describeModelVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDetectorVersionResult getDetectorVersion(GetDetectorVersionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetDetectorVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDetectorVersionResult executeGetDetectorVersion(GetDetectorVersionRequest getDetectorVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDetectorVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDetectorVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDetectorVersionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getDetectorVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetDetectorVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDetectorVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDetectorVersionResult getDetectorVersionResult = (GetDetectorVersionResult)response.getAwsResponse();
            return getDetectorVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDetectorsResult getDetectors(GetDetectorsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetDetectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDetectorsResult executeGetDetectors(GetDetectorsRequest getDetectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDetectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDetectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDetectorsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getDetectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetDetectors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDetectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDetectorsResult getDetectorsResult = (GetDetectorsResult)response.getAwsResponse();
            return getDetectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEntityTypesResult getEntityTypes(GetEntityTypesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetEntityTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEntityTypesResult executeGetEntityTypes(GetEntityTypesRequest getEntityTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEntityTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEntityTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEntityTypesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getEntityTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetEntityTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetEntityTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEntityTypesResult getEntityTypesResult = (GetEntityTypesResult)response.getAwsResponse();
            return getEntityTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEventPredictionResult getEventPrediction(GetEventPredictionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetEventPrediction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEventPredictionResult executeGetEventPrediction(GetEventPredictionRequest getEventPredictionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEventPredictionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEventPredictionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEventPredictionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getEventPredictionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetEventPrediction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetEventPredictionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEventPredictionResult getEventPredictionResult = (GetEventPredictionResult)response.getAwsResponse();
            return getEventPredictionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEventTypesResult getEventTypes(GetEventTypesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetEventTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEventTypesResult executeGetEventTypes(GetEventTypesRequest getEventTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEventTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEventTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEventTypesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getEventTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetEventTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetEventTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEventTypesResult getEventTypesResult = (GetEventTypesResult)response.getAwsResponse();
            return getEventTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetExternalModelsResult getExternalModels(GetExternalModelsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetExternalModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetExternalModelsResult executeGetExternalModels(GetExternalModelsRequest getExternalModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getExternalModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetExternalModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetExternalModelsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getExternalModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetExternalModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetExternalModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetExternalModelsResult getExternalModelsResult = (GetExternalModelsResult)response.getAwsResponse();
            return getExternalModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetKMSEncryptionKeyResult getKMSEncryptionKey(GetKMSEncryptionKeyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetKMSEncryptionKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetKMSEncryptionKeyResult executeGetKMSEncryptionKey(GetKMSEncryptionKeyRequest getKMSEncryptionKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getKMSEncryptionKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetKMSEncryptionKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetKMSEncryptionKeyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getKMSEncryptionKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetKMSEncryptionKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetKMSEncryptionKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetKMSEncryptionKeyResult getKMSEncryptionKeyResult = (GetKMSEncryptionKeyResult)response.getAwsResponse();
            return getKMSEncryptionKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLabelsResult getLabels(GetLabelsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetLabels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLabelsResult executeGetLabels(GetLabelsRequest getLabelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLabelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLabelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLabelsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getLabelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetLabels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetLabelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLabelsResult getLabelsResult = (GetLabelsResult)response.getAwsResponse();
            return getLabelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetModelVersionResult getModelVersion(GetModelVersionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetModelVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetModelVersionResult executeGetModelVersion(GetModelVersionRequest getModelVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getModelVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetModelVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetModelVersionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getModelVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetModelVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetModelVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetModelVersionResult getModelVersionResult = (GetModelVersionResult)response.getAwsResponse();
            return getModelVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetModelsResult getModels(GetModelsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetModelsResult executeGetModels(GetModelsRequest getModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetModelsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetModelsResult getModelsResult = (GetModelsResult)response.getAwsResponse();
            return getModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOutcomesResult getOutcomes(GetOutcomesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetOutcomes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOutcomesResult executeGetOutcomes(GetOutcomesRequest getOutcomesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOutcomesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOutcomesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOutcomesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getOutcomesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetOutcomes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetOutcomesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOutcomesResult getOutcomesResult = (GetOutcomesResult)response.getAwsResponse();
            return getOutcomesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRulesResult getRules(GetRulesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetRules(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRulesResult executeGetRules(GetRulesRequest getRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRulesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetRules");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetRulesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRulesResult getRulesResult = (GetRulesResult)response.getAwsResponse();
            return getRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetVariablesResult getVariables(GetVariablesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetVariables(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetVariablesResult executeGetVariables(GetVariablesRequest getVariablesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getVariablesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVariablesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVariablesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getVariablesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetVariables");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetVariablesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetVariablesResult getVariablesResult = (GetVariablesResult)response.getAwsResponse();
            return getVariablesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutDetectorResult putDetector(PutDetectorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutDetector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutDetectorResult executePutDetector(PutDetectorRequest putDetectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putDetectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutDetectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutDetectorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putDetectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutDetector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutDetectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutDetectorResult putDetectorResult = (PutDetectorResult)response.getAwsResponse();
            return putDetectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutEntityTypeResult putEntityType(PutEntityTypeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutEntityType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutEntityTypeResult executePutEntityType(PutEntityTypeRequest putEntityTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEntityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEntityTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEntityTypeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putEntityTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutEntityType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutEntityTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutEntityTypeResult putEntityTypeResult = (PutEntityTypeResult)response.getAwsResponse();
            return putEntityTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutEventTypeResult putEventType(PutEventTypeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutEventType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutEventTypeResult executePutEventType(PutEventTypeRequest putEventTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEventTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEventTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEventTypeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putEventTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutEventType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutEventTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutEventTypeResult putEventTypeResult = (PutEventTypeResult)response.getAwsResponse();
            return putEventTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutExternalModelResult putExternalModel(PutExternalModelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutExternalModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutExternalModelResult executePutExternalModel(PutExternalModelRequest putExternalModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putExternalModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutExternalModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutExternalModelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putExternalModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutExternalModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutExternalModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutExternalModelResult putExternalModelResult = (PutExternalModelResult)response.getAwsResponse();
            return putExternalModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutKMSEncryptionKeyResult putKMSEncryptionKey(PutKMSEncryptionKeyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutKMSEncryptionKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutKMSEncryptionKeyResult executePutKMSEncryptionKey(PutKMSEncryptionKeyRequest putKMSEncryptionKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putKMSEncryptionKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutKMSEncryptionKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutKMSEncryptionKeyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putKMSEncryptionKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutKMSEncryptionKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutKMSEncryptionKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutKMSEncryptionKeyResult putKMSEncryptionKeyResult = (PutKMSEncryptionKeyResult)response.getAwsResponse();
            return putKMSEncryptionKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutLabelResult putLabel(PutLabelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutLabel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutLabelResult executePutLabel(PutLabelRequest putLabelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putLabelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutLabelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutLabelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putLabelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutLabel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutLabelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutLabelResult putLabelResult = (PutLabelResult)response.getAwsResponse();
            return putLabelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutOutcomeResult putOutcome(PutOutcomeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutOutcome(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutOutcomeResult executePutOutcome(PutOutcomeRequest putOutcomeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putOutcomeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutOutcomeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutOutcomeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putOutcomeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutOutcome");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutOutcomeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutOutcomeResult putOutcomeResult = (PutOutcomeResult)response.getAwsResponse();
            return putOutcomeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDetectorVersionResult updateDetectorVersion(UpdateDetectorVersionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateDetectorVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDetectorVersionResult executeUpdateDetectorVersion(UpdateDetectorVersionRequest updateDetectorVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDetectorVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDetectorVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDetectorVersionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateDetectorVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateDetectorVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateDetectorVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDetectorVersionResult updateDetectorVersionResult = (UpdateDetectorVersionResult)response.getAwsResponse();
            return updateDetectorVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDetectorVersionMetadataResult updateDetectorVersionMetadata(UpdateDetectorVersionMetadataRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateDetectorVersionMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDetectorVersionMetadataResult executeUpdateDetectorVersionMetadata(UpdateDetectorVersionMetadataRequest updateDetectorVersionMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDetectorVersionMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDetectorVersionMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDetectorVersionMetadataRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateDetectorVersionMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateDetectorVersionMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateDetectorVersionMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDetectorVersionMetadataResult updateDetectorVersionMetadataResult = (UpdateDetectorVersionMetadataResult)response.getAwsResponse();
            return updateDetectorVersionMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDetectorVersionStatusResult updateDetectorVersionStatus(UpdateDetectorVersionStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateDetectorVersionStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDetectorVersionStatusResult executeUpdateDetectorVersionStatus(UpdateDetectorVersionStatusRequest updateDetectorVersionStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDetectorVersionStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDetectorVersionStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDetectorVersionStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateDetectorVersionStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateDetectorVersionStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateDetectorVersionStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDetectorVersionStatusResult updateDetectorVersionStatusResult = (UpdateDetectorVersionStatusResult)response.getAwsResponse();
            return updateDetectorVersionStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateModelResult updateModel(UpdateModelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateModelResult executeUpdateModel(UpdateModelRequest updateModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateModelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateModelResult updateModelResult = (UpdateModelResult)response.getAwsResponse();
            return updateModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateModelVersionResult updateModelVersion(UpdateModelVersionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateModelVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateModelVersionResult executeUpdateModelVersion(UpdateModelVersionRequest updateModelVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateModelVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateModelVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateModelVersionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateModelVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateModelVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateModelVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateModelVersionResult updateModelVersionResult = (UpdateModelVersionResult)response.getAwsResponse();
            return updateModelVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateModelVersionStatusResult updateModelVersionStatus(UpdateModelVersionStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateModelVersionStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateModelVersionStatusResult executeUpdateModelVersionStatus(UpdateModelVersionStatusRequest updateModelVersionStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateModelVersionStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateModelVersionStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateModelVersionStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateModelVersionStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateModelVersionStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateModelVersionStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateModelVersionStatusResult updateModelVersionStatusResult = (UpdateModelVersionStatusResult)response.getAwsResponse();
            return updateModelVersionStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRuleMetadataResult updateRuleMetadata(UpdateRuleMetadataRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateRuleMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRuleMetadataResult executeUpdateRuleMetadata(UpdateRuleMetadataRequest updateRuleMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRuleMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRuleMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRuleMetadataRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateRuleMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateRuleMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateRuleMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRuleMetadataResult updateRuleMetadataResult = (UpdateRuleMetadataResult)response.getAwsResponse();
            return updateRuleMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRuleVersionResult updateRuleVersion(UpdateRuleVersionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateRuleVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRuleVersionResult executeUpdateRuleVersion(UpdateRuleVersionRequest updateRuleVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRuleVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRuleVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRuleVersionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateRuleVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateRuleVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateRuleVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRuleVersionResult updateRuleVersionResult = (UpdateRuleVersionResult)response.getAwsResponse();
            return updateRuleVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateVariableResult updateVariable(UpdateVariableRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateVariable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateVariableResult executeUpdateVariable(UpdateVariableRequest updateVariableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateVariableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateVariableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateVariableRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateVariableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateVariable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateVariableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateVariableResult updateVariableResult = (UpdateVariableResult)response.getAwsResponse();
            return updateVariableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

