/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticinference.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticinference.model.MemoryInfo;

@SdkInternalApi
public class MemoryInfoMarshaller {
    private static final MarshallingInfo<Integer> SIZEINMIB_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInMiB").build();
    private static final MemoryInfoMarshaller instance = new MemoryInfoMarshaller();

    public static MemoryInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(MemoryInfo memoryInfo, ProtocolMarshaller protocolMarshaller) {
        if (memoryInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(memoryInfo.getSizeInMiB(), SIZEINMIB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

