/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticinference.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticinference.model.LocationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeAcceleratorOfferingsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String locationType;
    private List<String> acceleratorTypes;

    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public DescribeAcceleratorOfferingsRequest withLocationType(String locationType) {
        this.setLocationType(locationType);
        return this;
    }

    public DescribeAcceleratorOfferingsRequest withLocationType(LocationType locationType) {
        this.locationType = locationType.toString();
        return this;
    }

    public List<String> getAcceleratorTypes() {
        return this.acceleratorTypes;
    }

    public void setAcceleratorTypes(Collection<String> acceleratorTypes) {
        if (acceleratorTypes == null) {
            this.acceleratorTypes = null;
            return;
        }
        this.acceleratorTypes = new ArrayList<String>(acceleratorTypes);
    }

    public DescribeAcceleratorOfferingsRequest withAcceleratorTypes(String ... acceleratorTypes) {
        if (this.acceleratorTypes == null) {
            this.setAcceleratorTypes(new ArrayList<String>(acceleratorTypes.length));
        }
        for (String ele : acceleratorTypes) {
            this.acceleratorTypes.add(ele);
        }
        return this;
    }

    public DescribeAcceleratorOfferingsRequest withAcceleratorTypes(Collection<String> acceleratorTypes) {
        this.setAcceleratorTypes(acceleratorTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLocationType() != null) {
            sb.append("LocationType: ").append(this.getLocationType()).append(",");
        }
        if (this.getAcceleratorTypes() != null) {
            sb.append("AcceleratorTypes: ").append(this.getAcceleratorTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorOfferingsRequest)) {
            return false;
        }
        DescribeAcceleratorOfferingsRequest other = (DescribeAcceleratorOfferingsRequest)obj;
        if (other.getLocationType() == null ^ this.getLocationType() == null) {
            return false;
        }
        if (other.getLocationType() != null && !other.getLocationType().equals(this.getLocationType())) {
            return false;
        }
        if (other.getAcceleratorTypes() == null ^ this.getAcceleratorTypes() == null) {
            return false;
        }
        return other.getAcceleratorTypes() == null || other.getAcceleratorTypes().equals(this.getAcceleratorTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLocationType() == null ? 0 : this.getLocationType().hashCode());
        hashCode = 31 * hashCode + (this.getAcceleratorTypes() == null ? 0 : this.getAcceleratorTypes().hashCode());
        return hashCode;
    }

    @Override
    public DescribeAcceleratorOfferingsRequest clone() {
        return (DescribeAcceleratorOfferingsRequest)super.clone();
    }
}

