/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ebs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ebs.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Long volumeSize;
    private String parentSnapshotId;
    private List<Tag> tags;
    private String description;
    private String clientToken;
    private Boolean encrypted;
    private String kmsKeyArn;
    private Integer timeout;

    public void setVolumeSize(Long volumeSize) {
        this.volumeSize = volumeSize;
    }

    public Long getVolumeSize() {
        return this.volumeSize;
    }

    public StartSnapshotRequest withVolumeSize(Long volumeSize) {
        this.setVolumeSize(volumeSize);
        return this;
    }

    public void setParentSnapshotId(String parentSnapshotId) {
        this.parentSnapshotId = parentSnapshotId;
    }

    public String getParentSnapshotId() {
        return this.parentSnapshotId;
    }

    public StartSnapshotRequest withParentSnapshotId(String parentSnapshotId) {
        this.setParentSnapshotId(parentSnapshotId);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public StartSnapshotRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public StartSnapshotRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public StartSnapshotRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public StartSnapshotRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public StartSnapshotRequest withEncrypted(Boolean encrypted) {
        this.setEncrypted(encrypted);
        return this;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    public StartSnapshotRequest withKmsKeyArn(String kmsKeyArn) {
        this.setKmsKeyArn(kmsKeyArn);
        return this;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public StartSnapshotRequest withTimeout(Integer timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVolumeSize() != null) {
            sb.append("VolumeSize: ").append(this.getVolumeSize()).append(",");
        }
        if (this.getParentSnapshotId() != null) {
            sb.append("ParentSnapshotId: ").append(this.getParentSnapshotId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getEncrypted() != null) {
            sb.append("Encrypted: ").append(this.getEncrypted()).append(",");
        }
        if (this.getKmsKeyArn() != null) {
            sb.append("KmsKeyArn: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTimeout() != null) {
            sb.append("Timeout: ").append(this.getTimeout());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSnapshotRequest)) {
            return false;
        }
        StartSnapshotRequest other = (StartSnapshotRequest)obj;
        if (other.getVolumeSize() == null ^ this.getVolumeSize() == null) {
            return false;
        }
        if (other.getVolumeSize() != null && !other.getVolumeSize().equals(this.getVolumeSize())) {
            return false;
        }
        if (other.getParentSnapshotId() == null ^ this.getParentSnapshotId() == null) {
            return false;
        }
        if (other.getParentSnapshotId() != null && !other.getParentSnapshotId().equals(this.getParentSnapshotId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getEncrypted() == null ^ this.getEncrypted() == null) {
            return false;
        }
        if (other.getEncrypted() != null && !other.getEncrypted().equals(this.getEncrypted())) {
            return false;
        }
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null) {
            return false;
        }
        if (other.getKmsKeyArn() != null && !other.getKmsKeyArn().equals(this.getKmsKeyArn())) {
            return false;
        }
        if (other.getTimeout() == null ^ this.getTimeout() == null) {
            return false;
        }
        return other.getTimeout() == null || other.getTimeout().equals(this.getTimeout());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumeSize() == null ? 0 : this.getVolumeSize().hashCode());
        hashCode = 31 * hashCode + (this.getParentSnapshotId() == null ? 0 : this.getParentSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getEncrypted() == null ? 0 : this.getEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyArn() == null ? 0 : this.getKmsKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.getTimeout() == null ? 0 : this.getTimeout().hashCode());
        return hashCode;
    }

    @Override
    public StartSnapshotRequest clone() {
        return (StartSnapshotRequest)super.clone();
    }
}

