/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.AssetSourceEntry;

@SdkInternalApi
public class AssetSourceEntryMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bucket").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final AssetSourceEntryMarshaller instance = new AssetSourceEntryMarshaller();

    public static AssetSourceEntryMarshaller getInstance() {
        return instance;
    }

    public void marshall(AssetSourceEntry assetSourceEntry, ProtocolMarshaller protocolMarshaller) {
        if (assetSourceEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(assetSourceEntry.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall(assetSourceEntry.getKey(), KEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

