/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.AutoScalingGroupConfiguration;
import com.amazonaws.services.computeoptimizer.model.UtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.transform.AutoScalingGroupRecommendationOptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoScalingGroupRecommendationOption
implements Serializable,
Cloneable,
StructuredPojo {
    private AutoScalingGroupConfiguration configuration;
    private List<UtilizationMetric> projectedUtilizationMetrics;
    private Double performanceRisk;
    private Integer rank;

    public void setConfiguration(AutoScalingGroupConfiguration configuration) {
        this.configuration = configuration;
    }

    public AutoScalingGroupConfiguration getConfiguration() {
        return this.configuration;
    }

    public AutoScalingGroupRecommendationOption withConfiguration(AutoScalingGroupConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public List<UtilizationMetric> getProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public void setProjectedUtilizationMetrics(Collection<UtilizationMetric> projectedUtilizationMetrics) {
        if (projectedUtilizationMetrics == null) {
            this.projectedUtilizationMetrics = null;
            return;
        }
        this.projectedUtilizationMetrics = new ArrayList<UtilizationMetric>(projectedUtilizationMetrics);
    }

    public AutoScalingGroupRecommendationOption withProjectedUtilizationMetrics(UtilizationMetric ... projectedUtilizationMetrics) {
        if (this.projectedUtilizationMetrics == null) {
            this.setProjectedUtilizationMetrics(new ArrayList<UtilizationMetric>(projectedUtilizationMetrics.length));
        }
        for (UtilizationMetric ele : projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics.add(ele);
        }
        return this;
    }

    public AutoScalingGroupRecommendationOption withProjectedUtilizationMetrics(Collection<UtilizationMetric> projectedUtilizationMetrics) {
        this.setProjectedUtilizationMetrics(projectedUtilizationMetrics);
        return this;
    }

    public void setPerformanceRisk(Double performanceRisk) {
        this.performanceRisk = performanceRisk;
    }

    public Double getPerformanceRisk() {
        return this.performanceRisk;
    }

    public AutoScalingGroupRecommendationOption withPerformanceRisk(Double performanceRisk) {
        this.setPerformanceRisk(performanceRisk);
        return this;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getRank() {
        return this.rank;
    }

    public AutoScalingGroupRecommendationOption withRank(Integer rank) {
        this.setRank(rank);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getProjectedUtilizationMetrics() != null) {
            sb.append("ProjectedUtilizationMetrics: ").append(this.getProjectedUtilizationMetrics()).append(",");
        }
        if (this.getPerformanceRisk() != null) {
            sb.append("PerformanceRisk: ").append(this.getPerformanceRisk()).append(",");
        }
        if (this.getRank() != null) {
            sb.append("Rank: ").append(this.getRank());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupRecommendationOption)) {
            return false;
        }
        AutoScalingGroupRecommendationOption other = (AutoScalingGroupRecommendationOption)obj;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getProjectedUtilizationMetrics() == null ^ this.getProjectedUtilizationMetrics() == null) {
            return false;
        }
        if (other.getProjectedUtilizationMetrics() != null && !other.getProjectedUtilizationMetrics().equals(this.getProjectedUtilizationMetrics())) {
            return false;
        }
        if (other.getPerformanceRisk() == null ^ this.getPerformanceRisk() == null) {
            return false;
        }
        if (other.getPerformanceRisk() != null && !other.getPerformanceRisk().equals(this.getPerformanceRisk())) {
            return false;
        }
        if (other.getRank() == null ^ this.getRank() == null) {
            return false;
        }
        return other.getRank() == null || other.getRank().equals(this.getRank());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getProjectedUtilizationMetrics() == null ? 0 : this.getProjectedUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceRisk() == null ? 0 : this.getPerformanceRisk().hashCode());
        hashCode = 31 * hashCode + (this.getRank() == null ? 0 : this.getRank().hashCode());
        return hashCode;
    }

    public AutoScalingGroupRecommendationOption clone() {
        try {
            return (AutoScalingGroupRecommendationOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingGroupRecommendationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

