/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurureviewer.model.Reaction;
import com.amazonaws.services.codegurureviewer.model.transform.RecommendationFeedbackSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecommendationFeedbackSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String recommendationId;
    private List<String> reactions;
    private String userId;

    public void setRecommendationId(String recommendationId) {
        this.recommendationId = recommendationId;
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public RecommendationFeedbackSummary withRecommendationId(String recommendationId) {
        this.setRecommendationId(recommendationId);
        return this;
    }

    public List<String> getReactions() {
        return this.reactions;
    }

    public void setReactions(Collection<String> reactions) {
        if (reactions == null) {
            this.reactions = null;
            return;
        }
        this.reactions = new ArrayList<String>(reactions);
    }

    public RecommendationFeedbackSummary withReactions(String ... reactions) {
        if (this.reactions == null) {
            this.setReactions(new ArrayList<String>(reactions.length));
        }
        for (String ele : reactions) {
            this.reactions.add(ele);
        }
        return this;
    }

    public RecommendationFeedbackSummary withReactions(Collection<String> reactions) {
        this.setReactions(reactions);
        return this;
    }

    public RecommendationFeedbackSummary withReactions(Reaction ... reactions) {
        ArrayList<String> reactionsCopy = new ArrayList<String>(reactions.length);
        for (Reaction value : reactions) {
            reactionsCopy.add(value.toString());
        }
        if (this.getReactions() == null) {
            this.setReactions(reactionsCopy);
        } else {
            this.getReactions().addAll(reactionsCopy);
        }
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public RecommendationFeedbackSummary withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecommendationId() != null) {
            sb.append("RecommendationId: ").append(this.getRecommendationId()).append(",");
        }
        if (this.getReactions() != null) {
            sb.append("Reactions: ").append(this.getReactions()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationFeedbackSummary)) {
            return false;
        }
        RecommendationFeedbackSummary other = (RecommendationFeedbackSummary)obj;
        if (other.getRecommendationId() == null ^ this.getRecommendationId() == null) {
            return false;
        }
        if (other.getRecommendationId() != null && !other.getRecommendationId().equals(this.getRecommendationId())) {
            return false;
        }
        if (other.getReactions() == null ^ this.getReactions() == null) {
            return false;
        }
        if (other.getReactions() != null && !other.getReactions().equals(this.getReactions())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        return other.getUserId() == null || other.getUserId().equals(this.getUserId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecommendationId() == null ? 0 : this.getRecommendationId().hashCode());
        hashCode = 31 * hashCode + (this.getReactions() == null ? 0 : this.getReactions().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        return hashCode;
    }

    public RecommendationFeedbackSummary clone() {
        try {
            return (RecommendationFeedbackSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommendationFeedbackSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

