/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurureviewer.model.Reaction;
import com.amazonaws.services.codegurureviewer.model.transform.RecommendationFeedbackMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RecommendationFeedback
implements Serializable,
Cloneable,
StructuredPojo {
    private String codeReviewArn;
    private String recommendationId;
    private List<String> reactions;
    private String userId;
    private Date createdTimeStamp;
    private Date lastUpdatedTimeStamp;

    public void setCodeReviewArn(String codeReviewArn) {
        this.codeReviewArn = codeReviewArn;
    }

    public String getCodeReviewArn() {
        return this.codeReviewArn;
    }

    public RecommendationFeedback withCodeReviewArn(String codeReviewArn) {
        this.setCodeReviewArn(codeReviewArn);
        return this;
    }

    public void setRecommendationId(String recommendationId) {
        this.recommendationId = recommendationId;
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public RecommendationFeedback withRecommendationId(String recommendationId) {
        this.setRecommendationId(recommendationId);
        return this;
    }

    public List<String> getReactions() {
        return this.reactions;
    }

    public void setReactions(Collection<String> reactions) {
        if (reactions == null) {
            this.reactions = null;
            return;
        }
        this.reactions = new ArrayList<String>(reactions);
    }

    public RecommendationFeedback withReactions(String ... reactions) {
        if (this.reactions == null) {
            this.setReactions(new ArrayList<String>(reactions.length));
        }
        for (String ele : reactions) {
            this.reactions.add(ele);
        }
        return this;
    }

    public RecommendationFeedback withReactions(Collection<String> reactions) {
        this.setReactions(reactions);
        return this;
    }

    public RecommendationFeedback withReactions(Reaction ... reactions) {
        ArrayList<String> reactionsCopy = new ArrayList<String>(reactions.length);
        for (Reaction value : reactions) {
            reactionsCopy.add(value.toString());
        }
        if (this.getReactions() == null) {
            this.setReactions(reactionsCopy);
        } else {
            this.getReactions().addAll(reactionsCopy);
        }
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public RecommendationFeedback withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public void setCreatedTimeStamp(Date createdTimeStamp) {
        this.createdTimeStamp = createdTimeStamp;
    }

    public Date getCreatedTimeStamp() {
        return this.createdTimeStamp;
    }

    public RecommendationFeedback withCreatedTimeStamp(Date createdTimeStamp) {
        this.setCreatedTimeStamp(createdTimeStamp);
        return this;
    }

    public void setLastUpdatedTimeStamp(Date lastUpdatedTimeStamp) {
        this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
    }

    public Date getLastUpdatedTimeStamp() {
        return this.lastUpdatedTimeStamp;
    }

    public RecommendationFeedback withLastUpdatedTimeStamp(Date lastUpdatedTimeStamp) {
        this.setLastUpdatedTimeStamp(lastUpdatedTimeStamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCodeReviewArn() != null) {
            sb.append("CodeReviewArn: ").append(this.getCodeReviewArn()).append(",");
        }
        if (this.getRecommendationId() != null) {
            sb.append("RecommendationId: ").append(this.getRecommendationId()).append(",");
        }
        if (this.getReactions() != null) {
            sb.append("Reactions: ").append(this.getReactions()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId()).append(",");
        }
        if (this.getCreatedTimeStamp() != null) {
            sb.append("CreatedTimeStamp: ").append(this.getCreatedTimeStamp()).append(",");
        }
        if (this.getLastUpdatedTimeStamp() != null) {
            sb.append("LastUpdatedTimeStamp: ").append(this.getLastUpdatedTimeStamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationFeedback)) {
            return false;
        }
        RecommendationFeedback other = (RecommendationFeedback)obj;
        if (other.getCodeReviewArn() == null ^ this.getCodeReviewArn() == null) {
            return false;
        }
        if (other.getCodeReviewArn() != null && !other.getCodeReviewArn().equals(this.getCodeReviewArn())) {
            return false;
        }
        if (other.getRecommendationId() == null ^ this.getRecommendationId() == null) {
            return false;
        }
        if (other.getRecommendationId() != null && !other.getRecommendationId().equals(this.getRecommendationId())) {
            return false;
        }
        if (other.getReactions() == null ^ this.getReactions() == null) {
            return false;
        }
        if (other.getReactions() != null && !other.getReactions().equals(this.getReactions())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        if (other.getUserId() != null && !other.getUserId().equals(this.getUserId())) {
            return false;
        }
        if (other.getCreatedTimeStamp() == null ^ this.getCreatedTimeStamp() == null) {
            return false;
        }
        if (other.getCreatedTimeStamp() != null && !other.getCreatedTimeStamp().equals(this.getCreatedTimeStamp())) {
            return false;
        }
        if (other.getLastUpdatedTimeStamp() == null ^ this.getLastUpdatedTimeStamp() == null) {
            return false;
        }
        return other.getLastUpdatedTimeStamp() == null || other.getLastUpdatedTimeStamp().equals(this.getLastUpdatedTimeStamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCodeReviewArn() == null ? 0 : this.getCodeReviewArn().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationId() == null ? 0 : this.getRecommendationId().hashCode());
        hashCode = 31 * hashCode + (this.getReactions() == null ? 0 : this.getReactions().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTimeStamp() == null ? 0 : this.getCreatedTimeStamp().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTimeStamp() == null ? 0 : this.getLastUpdatedTimeStamp().hashCode());
        return hashCode;
    }

    public RecommendationFeedback clone() {
        try {
            return (RecommendationFeedback)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommendationFeedbackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

