/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codegurureviewer.model.Reaction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutRecommendationFeedbackRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String codeReviewArn;
    private String recommendationId;
    private List<String> reactions;

    public void setCodeReviewArn(String codeReviewArn) {
        this.codeReviewArn = codeReviewArn;
    }

    public String getCodeReviewArn() {
        return this.codeReviewArn;
    }

    public PutRecommendationFeedbackRequest withCodeReviewArn(String codeReviewArn) {
        this.setCodeReviewArn(codeReviewArn);
        return this;
    }

    public void setRecommendationId(String recommendationId) {
        this.recommendationId = recommendationId;
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public PutRecommendationFeedbackRequest withRecommendationId(String recommendationId) {
        this.setRecommendationId(recommendationId);
        return this;
    }

    public List<String> getReactions() {
        return this.reactions;
    }

    public void setReactions(Collection<String> reactions) {
        if (reactions == null) {
            this.reactions = null;
            return;
        }
        this.reactions = new ArrayList<String>(reactions);
    }

    public PutRecommendationFeedbackRequest withReactions(String ... reactions) {
        if (this.reactions == null) {
            this.setReactions(new ArrayList<String>(reactions.length));
        }
        for (String ele : reactions) {
            this.reactions.add(ele);
        }
        return this;
    }

    public PutRecommendationFeedbackRequest withReactions(Collection<String> reactions) {
        this.setReactions(reactions);
        return this;
    }

    public PutRecommendationFeedbackRequest withReactions(Reaction ... reactions) {
        ArrayList<String> reactionsCopy = new ArrayList<String>(reactions.length);
        for (Reaction value : reactions) {
            reactionsCopy.add(value.toString());
        }
        if (this.getReactions() == null) {
            this.setReactions(reactionsCopy);
        } else {
            this.getReactions().addAll(reactionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCodeReviewArn() != null) {
            sb.append("CodeReviewArn: ").append(this.getCodeReviewArn()).append(",");
        }
        if (this.getRecommendationId() != null) {
            sb.append("RecommendationId: ").append(this.getRecommendationId()).append(",");
        }
        if (this.getReactions() != null) {
            sb.append("Reactions: ").append(this.getReactions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecommendationFeedbackRequest)) {
            return false;
        }
        PutRecommendationFeedbackRequest other = (PutRecommendationFeedbackRequest)obj;
        if (other.getCodeReviewArn() == null ^ this.getCodeReviewArn() == null) {
            return false;
        }
        if (other.getCodeReviewArn() != null && !other.getCodeReviewArn().equals(this.getCodeReviewArn())) {
            return false;
        }
        if (other.getRecommendationId() == null ^ this.getRecommendationId() == null) {
            return false;
        }
        if (other.getRecommendationId() != null && !other.getRecommendationId().equals(this.getRecommendationId())) {
            return false;
        }
        if (other.getReactions() == null ^ this.getReactions() == null) {
            return false;
        }
        return other.getReactions() == null || other.getReactions().equals(this.getReactions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCodeReviewArn() == null ? 0 : this.getCodeReviewArn().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationId() == null ? 0 : this.getRecommendationId().hashCode());
        hashCode = 31 * hashCode + (this.getReactions() == null ? 0 : this.getReactions().hashCode());
        return hashCode;
    }

    @Override
    public PutRecommendationFeedbackRequest clone() {
        return (PutRecommendationFeedbackRequest)super.clone();
    }
}

