/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewer;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewerClientBuilder;
import com.amazonaws.services.codegurureviewer.model.AmazonCodeGuruReviewerException;
import com.amazonaws.services.codegurureviewer.model.AssociateRepositoryRequest;
import com.amazonaws.services.codegurureviewer.model.AssociateRepositoryResult;
import com.amazonaws.services.codegurureviewer.model.CreateCodeReviewRequest;
import com.amazonaws.services.codegurureviewer.model.CreateCodeReviewResult;
import com.amazonaws.services.codegurureviewer.model.DescribeCodeReviewRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeCodeReviewResult;
import com.amazonaws.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeRecommendationFeedbackResult;
import com.amazonaws.services.codegurureviewer.model.DescribeRepositoryAssociationRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeRepositoryAssociationResult;
import com.amazonaws.services.codegurureviewer.model.DisassociateRepositoryRequest;
import com.amazonaws.services.codegurureviewer.model.DisassociateRepositoryResult;
import com.amazonaws.services.codegurureviewer.model.ListCodeReviewsRequest;
import com.amazonaws.services.codegurureviewer.model.ListCodeReviewsResult;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationFeedbackRequest;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationFeedbackResult;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationsRequest;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationsResult;
import com.amazonaws.services.codegurureviewer.model.ListRepositoryAssociationsRequest;
import com.amazonaws.services.codegurureviewer.model.ListRepositoryAssociationsResult;
import com.amazonaws.services.codegurureviewer.model.PutRecommendationFeedbackRequest;
import com.amazonaws.services.codegurureviewer.model.PutRecommendationFeedbackResult;
import com.amazonaws.services.codegurureviewer.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.AssociateRepositoryRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.AssociateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.CreateCodeReviewRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.CreateCodeReviewResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeCodeReviewRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeCodeReviewResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeRecommendationFeedbackRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeRecommendationFeedbackResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeRepositoryAssociationRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeRepositoryAssociationResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DisassociateRepositoryRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DisassociateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListCodeReviewsRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListCodeReviewsResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRecommendationFeedbackRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRecommendationFeedbackResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRepositoryAssociationsRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRepositoryAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.PutRecommendationFeedbackRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.PutRecommendationFeedbackResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonCodeGuruReviewerClient
extends AmazonWebServiceClient
implements AmazonCodeGuruReviewer {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCodeGuruReviewer.class);
    private static final String DEFAULT_SIGNING_NAME = "codeguru-reviewer";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller(AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller(ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller(NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonCodeGuruReviewerException.class));

    public static AmazonCodeGuruReviewerClientBuilder builder() {
        return AmazonCodeGuruReviewerClientBuilder.standard();
    }

    AmazonCodeGuruReviewerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonCodeGuruReviewerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("codeguru-reviewer.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codegurureviewer/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codegurureviewer/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateRepositoryResult associateRepository(AssociateRepositoryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateRepository(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateRepositoryResult executeAssociateRepository(AssociateRepositoryRequest associateRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateRepositoryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(associateRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AssociateRepository");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateRepositoryResult associateRepositoryResult = (AssociateRepositoryResult)response.getAwsResponse();
            return associateRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateCodeReviewResult createCodeReview(CreateCodeReviewRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateCodeReview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCodeReviewResult executeCreateCodeReview(CreateCodeReviewRequest createCodeReviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCodeReviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCodeReviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCodeReviewRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createCodeReviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateCodeReview");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateCodeReviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCodeReviewResult createCodeReviewResult = (CreateCodeReviewResult)response.getAwsResponse();
            return createCodeReviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeCodeReviewResult describeCodeReview(DescribeCodeReviewRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeCodeReview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeCodeReviewResult executeDescribeCodeReview(DescribeCodeReviewRequest describeCodeReviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCodeReviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCodeReviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCodeReviewRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeCodeReviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeCodeReview");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeCodeReviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCodeReviewResult describeCodeReviewResult = (DescribeCodeReviewResult)response.getAwsResponse();
            return describeCodeReviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRecommendationFeedbackResult describeRecommendationFeedback(DescribeRecommendationFeedbackRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeRecommendationFeedback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRecommendationFeedbackResult executeDescribeRecommendationFeedback(DescribeRecommendationFeedbackRequest describeRecommendationFeedbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRecommendationFeedbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRecommendationFeedbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRecommendationFeedbackRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeRecommendationFeedbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeRecommendationFeedback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeRecommendationFeedbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRecommendationFeedbackResult describeRecommendationFeedbackResult = (DescribeRecommendationFeedbackResult)response.getAwsResponse();
            return describeRecommendationFeedbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRepositoryAssociationResult describeRepositoryAssociation(DescribeRepositoryAssociationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeRepositoryAssociation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRepositoryAssociationResult executeDescribeRepositoryAssociation(DescribeRepositoryAssociationRequest describeRepositoryAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRepositoryAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRepositoryAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRepositoryAssociationRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeRepositoryAssociationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeRepositoryAssociation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeRepositoryAssociationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRepositoryAssociationResult describeRepositoryAssociationResult = (DescribeRepositoryAssociationResult)response.getAwsResponse();
            return describeRepositoryAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateRepositoryResult disassociateRepository(DisassociateRepositoryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateRepository(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateRepositoryResult executeDisassociateRepository(DisassociateRepositoryRequest disassociateRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateRepositoryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DisassociateRepository");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateRepositoryResult disassociateRepositoryResult = (DisassociateRepositoryResult)response.getAwsResponse();
            return disassociateRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCodeReviewsResult listCodeReviews(ListCodeReviewsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListCodeReviews(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCodeReviewsResult executeListCodeReviews(ListCodeReviewsRequest listCodeReviewsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCodeReviewsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCodeReviewsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCodeReviewsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listCodeReviewsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListCodeReviews");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListCodeReviewsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCodeReviewsResult listCodeReviewsResult = (ListCodeReviewsResult)response.getAwsResponse();
            return listCodeReviewsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecommendationFeedbackResult listRecommendationFeedback(ListRecommendationFeedbackRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListRecommendationFeedback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecommendationFeedbackResult executeListRecommendationFeedback(ListRecommendationFeedbackRequest listRecommendationFeedbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecommendationFeedbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecommendationFeedbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecommendationFeedbackRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listRecommendationFeedbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListRecommendationFeedback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRecommendationFeedbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecommendationFeedbackResult listRecommendationFeedbackResult = (ListRecommendationFeedbackResult)response.getAwsResponse();
            return listRecommendationFeedbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecommendationsResult listRecommendations(ListRecommendationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecommendationsResult executeListRecommendations(ListRecommendationsRequest listRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecommendationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecommendationsResult listRecommendationsResult = (ListRecommendationsResult)response.getAwsResponse();
            return listRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRepositoryAssociationsResult listRepositoryAssociations(ListRepositoryAssociationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListRepositoryAssociations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRepositoryAssociationsResult executeListRepositoryAssociations(ListRepositoryAssociationsRequest listRepositoryAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRepositoryAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRepositoryAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRepositoryAssociationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listRepositoryAssociationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListRepositoryAssociations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRepositoryAssociationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRepositoryAssociationsResult listRepositoryAssociationsResult = (ListRepositoryAssociationsResult)response.getAwsResponse();
            return listRepositoryAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRecommendationFeedbackResult putRecommendationFeedback(PutRecommendationFeedbackRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutRecommendationFeedback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRecommendationFeedbackResult executePutRecommendationFeedback(PutRecommendationFeedbackRequest putRecommendationFeedbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRecommendationFeedbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRecommendationFeedbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRecommendationFeedbackRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putRecommendationFeedbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutRecommendationFeedback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutRecommendationFeedbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRecommendationFeedbackResult putRecommendationFeedbackResult = (PutRecommendationFeedbackResult)response.getAwsResponse();
            return putRecommendationFeedbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

