/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model.transform;

import com.amazonaws.services.codeguruprofiler.model.Metric;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class MetricJsonUnmarshaller
implements Unmarshaller<Metric, JsonUnmarshallerContext> {
    private static MetricJsonUnmarshaller instance;

    @Override
    public Metric unmarshall(JsonUnmarshallerContext context) throws Exception {
        Metric metric = new Metric();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("frameName", targetDepth)) {
                    context.nextToken();
                    metric.setFrameName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("threadStates", targetDepth)) {
                    context.nextToken();
                    metric.setThreadStates(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    metric.setType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return metric;
    }

    public static MetricJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricJsonUnmarshaller();
        }
        return instance;
    }
}

