/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeguruprofiler.model.Match;
import com.amazonaws.services.codeguruprofiler.model.Pattern;
import com.amazonaws.services.codeguruprofiler.model.transform.RecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Recommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer allMatchesCount;
    private Double allMatchesSum;
    private Date endTime;
    private Pattern pattern;
    private Date startTime;
    private List<Match> topMatches;

    public void setAllMatchesCount(Integer allMatchesCount) {
        this.allMatchesCount = allMatchesCount;
    }

    public Integer getAllMatchesCount() {
        return this.allMatchesCount;
    }

    public Recommendation withAllMatchesCount(Integer allMatchesCount) {
        this.setAllMatchesCount(allMatchesCount);
        return this;
    }

    public void setAllMatchesSum(Double allMatchesSum) {
        this.allMatchesSum = allMatchesSum;
    }

    public Double getAllMatchesSum() {
        return this.allMatchesSum;
    }

    public Recommendation withAllMatchesSum(Double allMatchesSum) {
        this.setAllMatchesSum(allMatchesSum);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Recommendation withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Recommendation withPattern(Pattern pattern) {
        this.setPattern(pattern);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Recommendation withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public List<Match> getTopMatches() {
        return this.topMatches;
    }

    public void setTopMatches(Collection<Match> topMatches) {
        if (topMatches == null) {
            this.topMatches = null;
            return;
        }
        this.topMatches = new ArrayList<Match>(topMatches);
    }

    public Recommendation withTopMatches(Match ... topMatches) {
        if (this.topMatches == null) {
            this.setTopMatches(new ArrayList<Match>(topMatches.length));
        }
        for (Match ele : topMatches) {
            this.topMatches.add(ele);
        }
        return this;
    }

    public Recommendation withTopMatches(Collection<Match> topMatches) {
        this.setTopMatches(topMatches);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllMatchesCount() != null) {
            sb.append("AllMatchesCount: ").append(this.getAllMatchesCount()).append(",");
        }
        if (this.getAllMatchesSum() != null) {
            sb.append("AllMatchesSum: ").append(this.getAllMatchesSum()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getPattern() != null) {
            sb.append("Pattern: ").append(this.getPattern()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getTopMatches() != null) {
            sb.append("TopMatches: ").append(this.getTopMatches());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        if (other.getAllMatchesCount() == null ^ this.getAllMatchesCount() == null) {
            return false;
        }
        if (other.getAllMatchesCount() != null && !other.getAllMatchesCount().equals(this.getAllMatchesCount())) {
            return false;
        }
        if (other.getAllMatchesSum() == null ^ this.getAllMatchesSum() == null) {
            return false;
        }
        if (other.getAllMatchesSum() != null && !other.getAllMatchesSum().equals(this.getAllMatchesSum())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getPattern() == null ^ this.getPattern() == null) {
            return false;
        }
        if (other.getPattern() != null && !other.getPattern().equals(this.getPattern())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getTopMatches() == null ^ this.getTopMatches() == null) {
            return false;
        }
        return other.getTopMatches() == null || other.getTopMatches().equals(this.getTopMatches());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllMatchesCount() == null ? 0 : this.getAllMatchesCount().hashCode());
        hashCode = 31 * hashCode + (this.getAllMatchesSum() == null ? 0 : this.getAllMatchesSum().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getPattern() == null ? 0 : this.getPattern().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getTopMatches() == null ? 0 : this.getTopMatches().hashCode());
        return hashCode;
    }

    public Recommendation clone() {
        try {
            return (Recommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

