/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeguruprofiler.model.Channel;
import com.amazonaws.services.codeguruprofiler.model.transform.NotificationConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NotificationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Channel> channels;

    public List<Channel> getChannels() {
        return this.channels;
    }

    public void setChannels(Collection<Channel> channels) {
        if (channels == null) {
            this.channels = null;
            return;
        }
        this.channels = new ArrayList<Channel>(channels);
    }

    public NotificationConfiguration withChannels(Channel ... channels) {
        if (this.channels == null) {
            this.setChannels(new ArrayList<Channel>(channels.length));
        }
        for (Channel ele : channels) {
            this.channels.add(ele);
        }
        return this;
    }

    public NotificationConfiguration withChannels(Collection<Channel> channels) {
        this.setChannels(channels);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannels() != null) {
            sb.append("Channels: ").append(this.getChannels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration)obj;
        if (other.getChannels() == null ^ this.getChannels() == null) {
            return false;
        }
        return other.getChannels() == null || other.getChannels().equals(this.getChannels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannels() == null ? 0 : this.getChannels().hashCode());
        return hashCode;
    }

    public NotificationConfiguration clone() {
        try {
            return (NotificationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

