/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeguruprofiler.model.AnomalyInstance;
import com.amazonaws.services.codeguruprofiler.model.Metric;
import com.amazonaws.services.codeguruprofiler.model.transform.AnomalyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Anomaly
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AnomalyInstance> instances;
    private Metric metric;
    private String reason;

    public List<AnomalyInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<AnomalyInstance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new ArrayList<AnomalyInstance>(instances);
    }

    public Anomaly withInstances(AnomalyInstance ... instances) {
        if (this.instances == null) {
            this.setInstances(new ArrayList<AnomalyInstance>(instances.length));
        }
        for (AnomalyInstance ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public Anomaly withInstances(Collection<AnomalyInstance> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public Anomaly withMetric(Metric metric) {
        this.setMetric(metric);
        return this;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public Anomaly withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getMetric() != null) {
            sb.append("Metric: ").append(this.getMetric()).append(",");
        }
        if (this.getReason() != null) {
            sb.append("Reason: ").append(this.getReason());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getMetric() == null ^ this.getMetric() == null) {
            return false;
        }
        if (other.getMetric() != null && !other.getMetric().equals(this.getMetric())) {
            return false;
        }
        if (other.getReason() == null ^ this.getReason() == null) {
            return false;
        }
        return other.getReason() == null || other.getReason().equals(this.getReason());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getMetric() == null ? 0 : this.getMetric().hashCode());
        hashCode = 31 * hashCode + (this.getReason() == null ? 0 : this.getReason().hashCode());
        return hashCode;
    }

    public Anomaly clone() {
        try {
            return (Anomaly)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnomalyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

