/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codeartifact.model.PackageVersionDescription;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class PackageVersionDescriptionMarshaller {
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("format").build();
    private static final MarshallingInfo<String> NAMESPACE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("namespace").build();
    private static final MarshallingInfo<String> PACKAGENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("packageName").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayName").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("summary").build();
    private static final MarshallingInfo<String> HOMEPAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("homePage").build();
    private static final MarshallingInfo<String> SOURCECODEREPOSITORY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceCodeRepository").build();
    private static final MarshallingInfo<Date> PUBLISHEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publishedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> LICENSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenses").build();
    private static final MarshallingInfo<String> REVISION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final PackageVersionDescriptionMarshaller instance = new PackageVersionDescriptionMarshaller();

    public static PackageVersionDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(PackageVersionDescription packageVersionDescription, ProtocolMarshaller protocolMarshaller) {
        if (packageVersionDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(packageVersionDescription.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getNamespace(), NAMESPACE_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getPackageName(), PACKAGENAME_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getSummary(), SUMMARY_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getHomePage(), HOMEPAGE_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getSourceCodeRepository(), SOURCECODEREPOSITORY_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getPublishedTime(), PUBLISHEDTIME_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getLicenses(), LICENSES_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getRevision(), REVISION_BINDING);
            protocolMarshaller.marshall(packageVersionDescription.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

