/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codeartifact.model.PackageFormat;
import com.amazonaws.services.codeartifact.model.PackageVersionStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdatePackageVersionsStatusRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domain;
    private String domainOwner;
    private String repository;
    private String format;
    private String namespace;
    private String packageValue;
    private List<String> versions;
    private Map<String, String> versionRevisions;
    private String expectedStatus;
    private String targetStatus;

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public UpdatePackageVersionsStatusRequest withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public void setDomainOwner(String domainOwner) {
        this.domainOwner = domainOwner;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public UpdatePackageVersionsStatusRequest withDomainOwner(String domainOwner) {
        this.setDomainOwner(domainOwner);
        return this;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }

    public UpdatePackageVersionsStatusRequest withRepository(String repository) {
        this.setRepository(repository);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public UpdatePackageVersionsStatusRequest withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public UpdatePackageVersionsStatusRequest withFormat(PackageFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public UpdatePackageVersionsStatusRequest withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setPackage(String packageValue) {
        this.packageValue = packageValue;
    }

    public String getPackage() {
        return this.packageValue;
    }

    public UpdatePackageVersionsStatusRequest withPackage(String packageValue) {
        this.setPackage(packageValue);
        return this;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public void setVersions(Collection<String> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        this.versions = new ArrayList<String>(versions);
    }

    public UpdatePackageVersionsStatusRequest withVersions(String ... versions) {
        if (this.versions == null) {
            this.setVersions(new ArrayList<String>(versions.length));
        }
        for (String ele : versions) {
            this.versions.add(ele);
        }
        return this;
    }

    public UpdatePackageVersionsStatusRequest withVersions(Collection<String> versions) {
        this.setVersions(versions);
        return this;
    }

    public Map<String, String> getVersionRevisions() {
        return this.versionRevisions;
    }

    public void setVersionRevisions(Map<String, String> versionRevisions) {
        this.versionRevisions = versionRevisions;
    }

    public UpdatePackageVersionsStatusRequest withVersionRevisions(Map<String, String> versionRevisions) {
        this.setVersionRevisions(versionRevisions);
        return this;
    }

    public UpdatePackageVersionsStatusRequest addVersionRevisionsEntry(String key, String value) {
        if (null == this.versionRevisions) {
            this.versionRevisions = new HashMap<String, String>();
        }
        if (this.versionRevisions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.versionRevisions.put(key, value);
        return this;
    }

    public UpdatePackageVersionsStatusRequest clearVersionRevisionsEntries() {
        this.versionRevisions = null;
        return this;
    }

    public void setExpectedStatus(String expectedStatus) {
        this.expectedStatus = expectedStatus;
    }

    public String getExpectedStatus() {
        return this.expectedStatus;
    }

    public UpdatePackageVersionsStatusRequest withExpectedStatus(String expectedStatus) {
        this.setExpectedStatus(expectedStatus);
        return this;
    }

    public UpdatePackageVersionsStatusRequest withExpectedStatus(PackageVersionStatus expectedStatus) {
        this.expectedStatus = expectedStatus.toString();
        return this;
    }

    public void setTargetStatus(String targetStatus) {
        this.targetStatus = targetStatus;
    }

    public String getTargetStatus() {
        return this.targetStatus;
    }

    public UpdatePackageVersionsStatusRequest withTargetStatus(String targetStatus) {
        this.setTargetStatus(targetStatus);
        return this;
    }

    public UpdatePackageVersionsStatusRequest withTargetStatus(PackageVersionStatus targetStatus) {
        this.targetStatus = targetStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomain() != null) {
            sb.append("Domain: ").append(this.getDomain()).append(",");
        }
        if (this.getDomainOwner() != null) {
            sb.append("DomainOwner: ").append(this.getDomainOwner()).append(",");
        }
        if (this.getRepository() != null) {
            sb.append("Repository: ").append(this.getRepository()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getPackage() != null) {
            sb.append("Package: ").append(this.getPackage()).append(",");
        }
        if (this.getVersions() != null) {
            sb.append("Versions: ").append(this.getVersions()).append(",");
        }
        if (this.getVersionRevisions() != null) {
            sb.append("VersionRevisions: ").append(this.getVersionRevisions()).append(",");
        }
        if (this.getExpectedStatus() != null) {
            sb.append("ExpectedStatus: ").append(this.getExpectedStatus()).append(",");
        }
        if (this.getTargetStatus() != null) {
            sb.append("TargetStatus: ").append(this.getTargetStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageVersionsStatusRequest)) {
            return false;
        }
        UpdatePackageVersionsStatusRequest other = (UpdatePackageVersionsStatusRequest)obj;
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getDomainOwner() == null ^ this.getDomainOwner() == null) {
            return false;
        }
        if (other.getDomainOwner() != null && !other.getDomainOwner().equals(this.getDomainOwner())) {
            return false;
        }
        if (other.getRepository() == null ^ this.getRepository() == null) {
            return false;
        }
        if (other.getRepository() != null && !other.getRepository().equals(this.getRepository())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getPackage() == null ^ this.getPackage() == null) {
            return false;
        }
        if (other.getPackage() != null && !other.getPackage().equals(this.getPackage())) {
            return false;
        }
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        if (other.getVersions() != null && !other.getVersions().equals(this.getVersions())) {
            return false;
        }
        if (other.getVersionRevisions() == null ^ this.getVersionRevisions() == null) {
            return false;
        }
        if (other.getVersionRevisions() != null && !other.getVersionRevisions().equals(this.getVersionRevisions())) {
            return false;
        }
        if (other.getExpectedStatus() == null ^ this.getExpectedStatus() == null) {
            return false;
        }
        if (other.getExpectedStatus() != null && !other.getExpectedStatus().equals(this.getExpectedStatus())) {
            return false;
        }
        if (other.getTargetStatus() == null ^ this.getTargetStatus() == null) {
            return false;
        }
        return other.getTargetStatus() == null || other.getTargetStatus().equals(this.getTargetStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getDomainOwner() == null ? 0 : this.getDomainOwner().hashCode());
        hashCode = 31 * hashCode + (this.getRepository() == null ? 0 : this.getRepository().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getPackage() == null ? 0 : this.getPackage().hashCode());
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        hashCode = 31 * hashCode + (this.getVersionRevisions() == null ? 0 : this.getVersionRevisions().hashCode());
        hashCode = 31 * hashCode + (this.getExpectedStatus() == null ? 0 : this.getExpectedStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTargetStatus() == null ? 0 : this.getTargetStatus().hashCode());
        return hashCode;
    }

    @Override
    public UpdatePackageVersionsStatusRequest clone() {
        return (UpdatePackageVersionsStatusRequest)super.clone();
    }
}

