/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeartifact.model.transform.PackageDependencyMarshaller;
import java.io.Serializable;

public class PackageDependency
implements Serializable,
Cloneable,
StructuredPojo {
    private String namespace;
    private String packageValue;
    private String dependencyType;
    private String versionRequirement;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public PackageDependency withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setPackage(String packageValue) {
        this.packageValue = packageValue;
    }

    public String getPackage() {
        return this.packageValue;
    }

    public PackageDependency withPackage(String packageValue) {
        this.setPackage(packageValue);
        return this;
    }

    public void setDependencyType(String dependencyType) {
        this.dependencyType = dependencyType;
    }

    public String getDependencyType() {
        return this.dependencyType;
    }

    public PackageDependency withDependencyType(String dependencyType) {
        this.setDependencyType(dependencyType);
        return this;
    }

    public void setVersionRequirement(String versionRequirement) {
        this.versionRequirement = versionRequirement;
    }

    public String getVersionRequirement() {
        return this.versionRequirement;
    }

    public PackageDependency withVersionRequirement(String versionRequirement) {
        this.setVersionRequirement(versionRequirement);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getPackage() != null) {
            sb.append("Package: ").append(this.getPackage()).append(",");
        }
        if (this.getDependencyType() != null) {
            sb.append("DependencyType: ").append(this.getDependencyType()).append(",");
        }
        if (this.getVersionRequirement() != null) {
            sb.append("VersionRequirement: ").append(this.getVersionRequirement());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDependency)) {
            return false;
        }
        PackageDependency other = (PackageDependency)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getPackage() == null ^ this.getPackage() == null) {
            return false;
        }
        if (other.getPackage() != null && !other.getPackage().equals(this.getPackage())) {
            return false;
        }
        if (other.getDependencyType() == null ^ this.getDependencyType() == null) {
            return false;
        }
        if (other.getDependencyType() != null && !other.getDependencyType().equals(this.getDependencyType())) {
            return false;
        }
        if (other.getVersionRequirement() == null ^ this.getVersionRequirement() == null) {
            return false;
        }
        return other.getVersionRequirement() == null || other.getVersionRequirement().equals(this.getVersionRequirement());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getPackage() == null ? 0 : this.getPackage().hashCode());
        hashCode = 31 * hashCode + (this.getDependencyType() == null ? 0 : this.getDependencyType().hashCode());
        hashCode = 31 * hashCode + (this.getVersionRequirement() == null ? 0 : this.getVersionRequirement().hashCode());
        return hashCode;
    }

    public PackageDependency clone() {
        try {
            return (PackageDependency)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PackageDependencyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

