/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeartifact.model.transform.AssetSummaryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AssetSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Long size;
    private Map<String, String> hashes;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AssetSummary withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getSize() {
        return this.size;
    }

    public AssetSummary withSize(Long size) {
        this.setSize(size);
        return this;
    }

    public Map<String, String> getHashes() {
        return this.hashes;
    }

    public void setHashes(Map<String, String> hashes) {
        this.hashes = hashes;
    }

    public AssetSummary withHashes(Map<String, String> hashes) {
        this.setHashes(hashes);
        return this;
    }

    public AssetSummary addHashesEntry(String key, String value) {
        if (null == this.hashes) {
            this.hashes = new HashMap<String, String>();
        }
        if (this.hashes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.hashes.put(key, value);
        return this;
    }

    public AssetSummary clearHashesEntries() {
        this.hashes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSize() != null) {
            sb.append("Size: ").append(this.getSize()).append(",");
        }
        if (this.getHashes() != null) {
            sb.append("Hashes: ").append(this.getHashes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetSummary)) {
            return false;
        }
        AssetSummary other = (AssetSummary)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSize() == null ^ this.getSize() == null) {
            return false;
        }
        if (other.getSize() != null && !other.getSize().equals(this.getSize())) {
            return false;
        }
        if (other.getHashes() == null ^ this.getHashes() == null) {
            return false;
        }
        return other.getHashes() == null || other.getHashes().equals(this.getHashes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSize() == null ? 0 : this.getSize().hashCode());
        hashCode = 31 * hashCode + (this.getHashes() == null ? 0 : this.getHashes().hashCode());
        return hashCode;
    }

    public AssetSummary clone() {
        try {
            return (AssetSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssetSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

