/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.braket;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.braket.AWSBraketAsync;
import com.amazonaws.services.braket.AWSBraketAsyncClientBuilder;
import com.amazonaws.services.braket.AWSBraketClient;
import com.amazonaws.services.braket.model.CancelQuantumTaskRequest;
import com.amazonaws.services.braket.model.CancelQuantumTaskResult;
import com.amazonaws.services.braket.model.CreateQuantumTaskRequest;
import com.amazonaws.services.braket.model.CreateQuantumTaskResult;
import com.amazonaws.services.braket.model.GetDeviceRequest;
import com.amazonaws.services.braket.model.GetDeviceResult;
import com.amazonaws.services.braket.model.GetQuantumTaskRequest;
import com.amazonaws.services.braket.model.GetQuantumTaskResult;
import com.amazonaws.services.braket.model.SearchDevicesRequest;
import com.amazonaws.services.braket.model.SearchDevicesResult;
import com.amazonaws.services.braket.model.SearchQuantumTasksRequest;
import com.amazonaws.services.braket.model.SearchQuantumTasksResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSBraketAsyncClient
extends AWSBraketClient
implements AWSBraketAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSBraketAsyncClientBuilder asyncBuilder() {
        return AWSBraketAsyncClientBuilder.standard();
    }

    AWSBraketAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSBraketAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelQuantumTaskResult> cancelQuantumTaskAsync(CancelQuantumTaskRequest request) {
        return this.cancelQuantumTaskAsync(request, null);
    }

    @Override
    public Future<CancelQuantumTaskResult> cancelQuantumTaskAsync(CancelQuantumTaskRequest request, final AsyncHandler<CancelQuantumTaskRequest, CancelQuantumTaskResult> asyncHandler) {
        final CancelQuantumTaskRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelQuantumTaskResult>(){

            @Override
            public CancelQuantumTaskResult call() throws Exception {
                CancelQuantumTaskResult result = null;
                try {
                    result = AWSBraketAsyncClient.this.executeCancelQuantumTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateQuantumTaskResult> createQuantumTaskAsync(CreateQuantumTaskRequest request) {
        return this.createQuantumTaskAsync(request, null);
    }

    @Override
    public Future<CreateQuantumTaskResult> createQuantumTaskAsync(CreateQuantumTaskRequest request, final AsyncHandler<CreateQuantumTaskRequest, CreateQuantumTaskResult> asyncHandler) {
        final CreateQuantumTaskRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateQuantumTaskResult>(){

            @Override
            public CreateQuantumTaskResult call() throws Exception {
                CreateQuantumTaskResult result = null;
                try {
                    result = AWSBraketAsyncClient.this.executeCreateQuantumTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeviceResult> getDeviceAsync(GetDeviceRequest request) {
        return this.getDeviceAsync(request, null);
    }

    @Override
    public Future<GetDeviceResult> getDeviceAsync(GetDeviceRequest request, final AsyncHandler<GetDeviceRequest, GetDeviceResult> asyncHandler) {
        final GetDeviceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDeviceResult>(){

            @Override
            public GetDeviceResult call() throws Exception {
                GetDeviceResult result = null;
                try {
                    result = AWSBraketAsyncClient.this.executeGetDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQuantumTaskResult> getQuantumTaskAsync(GetQuantumTaskRequest request) {
        return this.getQuantumTaskAsync(request, null);
    }

    @Override
    public Future<GetQuantumTaskResult> getQuantumTaskAsync(GetQuantumTaskRequest request, final AsyncHandler<GetQuantumTaskRequest, GetQuantumTaskResult> asyncHandler) {
        final GetQuantumTaskRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQuantumTaskResult>(){

            @Override
            public GetQuantumTaskResult call() throws Exception {
                GetQuantumTaskResult result = null;
                try {
                    result = AWSBraketAsyncClient.this.executeGetQuantumTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchDevicesResult> searchDevicesAsync(SearchDevicesRequest request) {
        return this.searchDevicesAsync(request, null);
    }

    @Override
    public Future<SearchDevicesResult> searchDevicesAsync(SearchDevicesRequest request, final AsyncHandler<SearchDevicesRequest, SearchDevicesResult> asyncHandler) {
        final SearchDevicesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchDevicesResult>(){

            @Override
            public SearchDevicesResult call() throws Exception {
                SearchDevicesResult result = null;
                try {
                    result = AWSBraketAsyncClient.this.executeSearchDevices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchQuantumTasksResult> searchQuantumTasksAsync(SearchQuantumTasksRequest request) {
        return this.searchQuantumTasksAsync(request, null);
    }

    @Override
    public Future<SearchQuantumTasksResult> searchQuantumTasksAsync(SearchQuantumTasksRequest request, final AsyncHandler<SearchQuantumTasksRequest, SearchQuantumTasksResult> asyncHandler) {
        final SearchQuantumTasksRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchQuantumTasksResult>(){

            @Override
            public SearchQuantumTasksResult call() throws Exception {
                SearchQuantumTasksResult result = null;
                try {
                    result = AWSBraketAsyncClient.this.executeSearchQuantumTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

