/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.Task;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class TaskMarshaller {
    private static final MarshallingInfo<List> SOURCEFIELDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceFields").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTOROPERATOR_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectorOperator").build();
    private static final MarshallingInfo<String> DESTINATIONFIELD_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationField").build();
    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskType").build();
    private static final MarshallingInfo<Map> TASKPROPERTIES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskProperties").build();
    private static final TaskMarshaller instance = new TaskMarshaller();

    public static TaskMarshaller getInstance() {
        return instance;
    }

    public void marshall(Task task, ProtocolMarshaller protocolMarshaller) {
        if (task == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(task.getSourceFields(), SOURCEFIELDS_BINDING);
            protocolMarshaller.marshall(task.getConnectorOperator(), CONNECTOROPERATOR_BINDING);
            protocolMarshaller.marshall(task.getDestinationField(), DESTINATIONFIELD_BINDING);
            protocolMarshaller.marshall(task.getTaskType(), TASKTYPE_BINDING);
            protocolMarshaller.marshall(task.getTaskProperties(), TASKPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

