/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appflow.model.ExecutionDetails;
import java.util.Date;

@SdkInternalApi
public class ExecutionDetailsMarshaller {
    private static final MarshallingInfo<String> MOSTRECENTEXECUTIONMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mostRecentExecutionMessage").build();
    private static final MarshallingInfo<Date> MOSTRECENTEXECUTIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mostRecentExecutionTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> MOSTRECENTEXECUTIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mostRecentExecutionStatus").build();
    private static final ExecutionDetailsMarshaller instance = new ExecutionDetailsMarshaller();

    public static ExecutionDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExecutionDetails executionDetails, ProtocolMarshaller protocolMarshaller) {
        if (executionDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(executionDetails.getMostRecentExecutionMessage(), MOSTRECENTEXECUTIONMESSAGE_BINDING);
            protocolMarshaller.marshall(executionDetails.getMostRecentExecutionTime(), MOSTRECENTEXECUTIONTIME_BINDING);
            protocolMarshaller.marshall(executionDetails.getMostRecentExecutionStatus(), MOSTRECENTEXECUTIONSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

