/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.DestinationConnectorProperties;

@SdkInternalApi
public class DestinationConnectorPropertiesMarshaller {
    private static final MarshallingInfo<StructuredPojo> REDSHIFT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Redshift").build();
    private static final MarshallingInfo<StructuredPojo> S3_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3").build();
    private static final MarshallingInfo<StructuredPojo> SALESFORCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Salesforce").build();
    private static final MarshallingInfo<StructuredPojo> SNOWFLAKE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Snowflake").build();
    private static final MarshallingInfo<StructuredPojo> EVENTBRIDGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventBridge").build();
    private static final DestinationConnectorPropertiesMarshaller instance = new DestinationConnectorPropertiesMarshaller();

    public static DestinationConnectorPropertiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(DestinationConnectorProperties destinationConnectorProperties, ProtocolMarshaller protocolMarshaller) {
        if (destinationConnectorProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(destinationConnectorProperties.getRedshift(), REDSHIFT_BINDING);
            protocolMarshaller.marshall(destinationConnectorProperties.getS3(), S3_BINDING);
            protocolMarshaller.marshall(destinationConnectorProperties.getSalesforce(), SALESFORCE_BINDING);
            protocolMarshaller.marshall(destinationConnectorProperties.getSnowflake(), SNOWFLAKE_BINDING);
            protocolMarshaller.marshall(destinationConnectorProperties.getEventBridge(), EVENTBRIDGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

