/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appflow.model.ConnectorEntity;

@SdkInternalApi
public class ConnectorEntityMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> LABEL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("label").build();
    private static final MarshallingInfo<Boolean> HASNESTEDENTITIES_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hasNestedEntities").build();
    private static final ConnectorEntityMarshaller instance = new ConnectorEntityMarshaller();

    public static ConnectorEntityMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConnectorEntity connectorEntity, ProtocolMarshaller protocolMarshaller) {
        if (connectorEntity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(connectorEntity.getName(), NAME_BINDING);
            protocolMarshaller.marshall(connectorEntity.getLabel(), LABEL_BINDING);
            protocolMarshaller.marshall(connectorEntity.getHasNestedEntities(), HASNESTEDENTITIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

