/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.Operator;
import com.amazonaws.services.appflow.model.transform.FieldTypeDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FieldTypeDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String fieldType;
    private List<String> filterOperators;
    private List<String> supportedValues;

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public FieldTypeDetails withFieldType(String fieldType) {
        this.setFieldType(fieldType);
        return this;
    }

    public List<String> getFilterOperators() {
        return this.filterOperators;
    }

    public void setFilterOperators(Collection<String> filterOperators) {
        if (filterOperators == null) {
            this.filterOperators = null;
            return;
        }
        this.filterOperators = new ArrayList<String>(filterOperators);
    }

    public FieldTypeDetails withFilterOperators(String ... filterOperators) {
        if (this.filterOperators == null) {
            this.setFilterOperators(new ArrayList<String>(filterOperators.length));
        }
        for (String ele : filterOperators) {
            this.filterOperators.add(ele);
        }
        return this;
    }

    public FieldTypeDetails withFilterOperators(Collection<String> filterOperators) {
        this.setFilterOperators(filterOperators);
        return this;
    }

    public FieldTypeDetails withFilterOperators(Operator ... filterOperators) {
        ArrayList<String> filterOperatorsCopy = new ArrayList<String>(filterOperators.length);
        for (Operator value : filterOperators) {
            filterOperatorsCopy.add(value.toString());
        }
        if (this.getFilterOperators() == null) {
            this.setFilterOperators(filterOperatorsCopy);
        } else {
            this.getFilterOperators().addAll(filterOperatorsCopy);
        }
        return this;
    }

    public List<String> getSupportedValues() {
        return this.supportedValues;
    }

    public void setSupportedValues(Collection<String> supportedValues) {
        if (supportedValues == null) {
            this.supportedValues = null;
            return;
        }
        this.supportedValues = new ArrayList<String>(supportedValues);
    }

    public FieldTypeDetails withSupportedValues(String ... supportedValues) {
        if (this.supportedValues == null) {
            this.setSupportedValues(new ArrayList<String>(supportedValues.length));
        }
        for (String ele : supportedValues) {
            this.supportedValues.add(ele);
        }
        return this;
    }

    public FieldTypeDetails withSupportedValues(Collection<String> supportedValues) {
        this.setSupportedValues(supportedValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFieldType() != null) {
            sb.append("FieldType: ").append(this.getFieldType()).append(",");
        }
        if (this.getFilterOperators() != null) {
            sb.append("FilterOperators: ").append(this.getFilterOperators()).append(",");
        }
        if (this.getSupportedValues() != null) {
            sb.append("SupportedValues: ").append(this.getSupportedValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldTypeDetails)) {
            return false;
        }
        FieldTypeDetails other = (FieldTypeDetails)obj;
        if (other.getFieldType() == null ^ this.getFieldType() == null) {
            return false;
        }
        if (other.getFieldType() != null && !other.getFieldType().equals(this.getFieldType())) {
            return false;
        }
        if (other.getFilterOperators() == null ^ this.getFilterOperators() == null) {
            return false;
        }
        if (other.getFilterOperators() != null && !other.getFilterOperators().equals(this.getFilterOperators())) {
            return false;
        }
        if (other.getSupportedValues() == null ^ this.getSupportedValues() == null) {
            return false;
        }
        return other.getSupportedValues() == null || other.getSupportedValues().equals(this.getSupportedValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFieldType() == null ? 0 : this.getFieldType().hashCode());
        hashCode = 31 * hashCode + (this.getFilterOperators() == null ? 0 : this.getFilterOperators().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedValues() == null ? 0 : this.getSupportedValues().hashCode());
        return hashCode;
    }

    public FieldTypeDetails clone() {
        try {
            return (FieldTypeDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FieldTypeDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

