/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.ConnectorMetadata;
import com.amazonaws.services.appflow.model.ConnectorType;
import com.amazonaws.services.appflow.model.ScheduleFrequencyType;
import com.amazonaws.services.appflow.model.TriggerType;
import com.amazonaws.services.appflow.model.transform.ConnectorConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConnectorConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean canUseAsSource;
    private Boolean canUseAsDestination;
    private List<String> supportedDestinationConnectors;
    private List<String> supportedSchedulingFrequencies;
    private Boolean isPrivateLinkEnabled;
    private Boolean isPrivateLinkEndpointUrlRequired;
    private List<String> supportedTriggerTypes;
    private ConnectorMetadata connectorMetadata;

    public void setCanUseAsSource(Boolean canUseAsSource) {
        this.canUseAsSource = canUseAsSource;
    }

    public Boolean getCanUseAsSource() {
        return this.canUseAsSource;
    }

    public ConnectorConfiguration withCanUseAsSource(Boolean canUseAsSource) {
        this.setCanUseAsSource(canUseAsSource);
        return this;
    }

    public Boolean isCanUseAsSource() {
        return this.canUseAsSource;
    }

    public void setCanUseAsDestination(Boolean canUseAsDestination) {
        this.canUseAsDestination = canUseAsDestination;
    }

    public Boolean getCanUseAsDestination() {
        return this.canUseAsDestination;
    }

    public ConnectorConfiguration withCanUseAsDestination(Boolean canUseAsDestination) {
        this.setCanUseAsDestination(canUseAsDestination);
        return this;
    }

    public Boolean isCanUseAsDestination() {
        return this.canUseAsDestination;
    }

    public List<String> getSupportedDestinationConnectors() {
        return this.supportedDestinationConnectors;
    }

    public void setSupportedDestinationConnectors(Collection<String> supportedDestinationConnectors) {
        if (supportedDestinationConnectors == null) {
            this.supportedDestinationConnectors = null;
            return;
        }
        this.supportedDestinationConnectors = new ArrayList<String>(supportedDestinationConnectors);
    }

    public ConnectorConfiguration withSupportedDestinationConnectors(String ... supportedDestinationConnectors) {
        if (this.supportedDestinationConnectors == null) {
            this.setSupportedDestinationConnectors(new ArrayList<String>(supportedDestinationConnectors.length));
        }
        for (String ele : supportedDestinationConnectors) {
            this.supportedDestinationConnectors.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withSupportedDestinationConnectors(Collection<String> supportedDestinationConnectors) {
        this.setSupportedDestinationConnectors(supportedDestinationConnectors);
        return this;
    }

    public ConnectorConfiguration withSupportedDestinationConnectors(ConnectorType ... supportedDestinationConnectors) {
        ArrayList<String> supportedDestinationConnectorsCopy = new ArrayList<String>(supportedDestinationConnectors.length);
        for (ConnectorType value : supportedDestinationConnectors) {
            supportedDestinationConnectorsCopy.add(value.toString());
        }
        if (this.getSupportedDestinationConnectors() == null) {
            this.setSupportedDestinationConnectors(supportedDestinationConnectorsCopy);
        } else {
            this.getSupportedDestinationConnectors().addAll(supportedDestinationConnectorsCopy);
        }
        return this;
    }

    public List<String> getSupportedSchedulingFrequencies() {
        return this.supportedSchedulingFrequencies;
    }

    public void setSupportedSchedulingFrequencies(Collection<String> supportedSchedulingFrequencies) {
        if (supportedSchedulingFrequencies == null) {
            this.supportedSchedulingFrequencies = null;
            return;
        }
        this.supportedSchedulingFrequencies = new ArrayList<String>(supportedSchedulingFrequencies);
    }

    public ConnectorConfiguration withSupportedSchedulingFrequencies(String ... supportedSchedulingFrequencies) {
        if (this.supportedSchedulingFrequencies == null) {
            this.setSupportedSchedulingFrequencies(new ArrayList<String>(supportedSchedulingFrequencies.length));
        }
        for (String ele : supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withSupportedSchedulingFrequencies(Collection<String> supportedSchedulingFrequencies) {
        this.setSupportedSchedulingFrequencies(supportedSchedulingFrequencies);
        return this;
    }

    public ConnectorConfiguration withSupportedSchedulingFrequencies(ScheduleFrequencyType ... supportedSchedulingFrequencies) {
        ArrayList<String> supportedSchedulingFrequenciesCopy = new ArrayList<String>(supportedSchedulingFrequencies.length);
        for (ScheduleFrequencyType value : supportedSchedulingFrequencies) {
            supportedSchedulingFrequenciesCopy.add(value.toString());
        }
        if (this.getSupportedSchedulingFrequencies() == null) {
            this.setSupportedSchedulingFrequencies(supportedSchedulingFrequenciesCopy);
        } else {
            this.getSupportedSchedulingFrequencies().addAll(supportedSchedulingFrequenciesCopy);
        }
        return this;
    }

    public void setIsPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
        this.isPrivateLinkEnabled = isPrivateLinkEnabled;
    }

    public Boolean getIsPrivateLinkEnabled() {
        return this.isPrivateLinkEnabled;
    }

    public ConnectorConfiguration withIsPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
        this.setIsPrivateLinkEnabled(isPrivateLinkEnabled);
        return this;
    }

    public Boolean isPrivateLinkEnabled() {
        return this.isPrivateLinkEnabled;
    }

    public void setIsPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
        this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
    }

    public Boolean getIsPrivateLinkEndpointUrlRequired() {
        return this.isPrivateLinkEndpointUrlRequired;
    }

    public ConnectorConfiguration withIsPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
        this.setIsPrivateLinkEndpointUrlRequired(isPrivateLinkEndpointUrlRequired);
        return this;
    }

    public Boolean isPrivateLinkEndpointUrlRequired() {
        return this.isPrivateLinkEndpointUrlRequired;
    }

    public List<String> getSupportedTriggerTypes() {
        return this.supportedTriggerTypes;
    }

    public void setSupportedTriggerTypes(Collection<String> supportedTriggerTypes) {
        if (supportedTriggerTypes == null) {
            this.supportedTriggerTypes = null;
            return;
        }
        this.supportedTriggerTypes = new ArrayList<String>(supportedTriggerTypes);
    }

    public ConnectorConfiguration withSupportedTriggerTypes(String ... supportedTriggerTypes) {
        if (this.supportedTriggerTypes == null) {
            this.setSupportedTriggerTypes(new ArrayList<String>(supportedTriggerTypes.length));
        }
        for (String ele : supportedTriggerTypes) {
            this.supportedTriggerTypes.add(ele);
        }
        return this;
    }

    public ConnectorConfiguration withSupportedTriggerTypes(Collection<String> supportedTriggerTypes) {
        this.setSupportedTriggerTypes(supportedTriggerTypes);
        return this;
    }

    public ConnectorConfiguration withSupportedTriggerTypes(TriggerType ... supportedTriggerTypes) {
        ArrayList<String> supportedTriggerTypesCopy = new ArrayList<String>(supportedTriggerTypes.length);
        for (TriggerType value : supportedTriggerTypes) {
            supportedTriggerTypesCopy.add(value.toString());
        }
        if (this.getSupportedTriggerTypes() == null) {
            this.setSupportedTriggerTypes(supportedTriggerTypesCopy);
        } else {
            this.getSupportedTriggerTypes().addAll(supportedTriggerTypesCopy);
        }
        return this;
    }

    public void setConnectorMetadata(ConnectorMetadata connectorMetadata) {
        this.connectorMetadata = connectorMetadata;
    }

    public ConnectorMetadata getConnectorMetadata() {
        return this.connectorMetadata;
    }

    public ConnectorConfiguration withConnectorMetadata(ConnectorMetadata connectorMetadata) {
        this.setConnectorMetadata(connectorMetadata);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCanUseAsSource() != null) {
            sb.append("CanUseAsSource: ").append(this.getCanUseAsSource()).append(",");
        }
        if (this.getCanUseAsDestination() != null) {
            sb.append("CanUseAsDestination: ").append(this.getCanUseAsDestination()).append(",");
        }
        if (this.getSupportedDestinationConnectors() != null) {
            sb.append("SupportedDestinationConnectors: ").append(this.getSupportedDestinationConnectors()).append(",");
        }
        if (this.getSupportedSchedulingFrequencies() != null) {
            sb.append("SupportedSchedulingFrequencies: ").append(this.getSupportedSchedulingFrequencies()).append(",");
        }
        if (this.getIsPrivateLinkEnabled() != null) {
            sb.append("IsPrivateLinkEnabled: ").append(this.getIsPrivateLinkEnabled()).append(",");
        }
        if (this.getIsPrivateLinkEndpointUrlRequired() != null) {
            sb.append("IsPrivateLinkEndpointUrlRequired: ").append(this.getIsPrivateLinkEndpointUrlRequired()).append(",");
        }
        if (this.getSupportedTriggerTypes() != null) {
            sb.append("SupportedTriggerTypes: ").append(this.getSupportedTriggerTypes()).append(",");
        }
        if (this.getConnectorMetadata() != null) {
            sb.append("ConnectorMetadata: ").append(this.getConnectorMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorConfiguration)) {
            return false;
        }
        ConnectorConfiguration other = (ConnectorConfiguration)obj;
        if (other.getCanUseAsSource() == null ^ this.getCanUseAsSource() == null) {
            return false;
        }
        if (other.getCanUseAsSource() != null && !other.getCanUseAsSource().equals(this.getCanUseAsSource())) {
            return false;
        }
        if (other.getCanUseAsDestination() == null ^ this.getCanUseAsDestination() == null) {
            return false;
        }
        if (other.getCanUseAsDestination() != null && !other.getCanUseAsDestination().equals(this.getCanUseAsDestination())) {
            return false;
        }
        if (other.getSupportedDestinationConnectors() == null ^ this.getSupportedDestinationConnectors() == null) {
            return false;
        }
        if (other.getSupportedDestinationConnectors() != null && !other.getSupportedDestinationConnectors().equals(this.getSupportedDestinationConnectors())) {
            return false;
        }
        if (other.getSupportedSchedulingFrequencies() == null ^ this.getSupportedSchedulingFrequencies() == null) {
            return false;
        }
        if (other.getSupportedSchedulingFrequencies() != null && !other.getSupportedSchedulingFrequencies().equals(this.getSupportedSchedulingFrequencies())) {
            return false;
        }
        if (other.getIsPrivateLinkEnabled() == null ^ this.getIsPrivateLinkEnabled() == null) {
            return false;
        }
        if (other.getIsPrivateLinkEnabled() != null && !other.getIsPrivateLinkEnabled().equals(this.getIsPrivateLinkEnabled())) {
            return false;
        }
        if (other.getIsPrivateLinkEndpointUrlRequired() == null ^ this.getIsPrivateLinkEndpointUrlRequired() == null) {
            return false;
        }
        if (other.getIsPrivateLinkEndpointUrlRequired() != null && !other.getIsPrivateLinkEndpointUrlRequired().equals(this.getIsPrivateLinkEndpointUrlRequired())) {
            return false;
        }
        if (other.getSupportedTriggerTypes() == null ^ this.getSupportedTriggerTypes() == null) {
            return false;
        }
        if (other.getSupportedTriggerTypes() != null && !other.getSupportedTriggerTypes().equals(this.getSupportedTriggerTypes())) {
            return false;
        }
        if (other.getConnectorMetadata() == null ^ this.getConnectorMetadata() == null) {
            return false;
        }
        return other.getConnectorMetadata() == null || other.getConnectorMetadata().equals(this.getConnectorMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCanUseAsSource() == null ? 0 : this.getCanUseAsSource().hashCode());
        hashCode = 31 * hashCode + (this.getCanUseAsDestination() == null ? 0 : this.getCanUseAsDestination().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedDestinationConnectors() == null ? 0 : this.getSupportedDestinationConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedSchedulingFrequencies() == null ? 0 : this.getSupportedSchedulingFrequencies().hashCode());
        hashCode = 31 * hashCode + (this.getIsPrivateLinkEnabled() == null ? 0 : this.getIsPrivateLinkEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getIsPrivateLinkEndpointUrlRequired() == null ? 0 : this.getIsPrivateLinkEndpointUrlRequired().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedTriggerTypes() == null ? 0 : this.getSupportedTriggerTypes().hashCode());
        hashCode = 31 * hashCode + (this.getConnectorMetadata() == null ? 0 : this.getConnectorMetadata().hashCode());
        return hashCode;
    }

    public ConnectorConfiguration clone() {
        try {
            return (ConnectorConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectorConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

