/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.Segment;
import com.amazonaws.services.xray.model.Trace;
import com.amazonaws.services.xray.model.transform.SegmentJsonMarshaller;
import java.util.List;

public class TraceJsonMarshaller {
    private static TraceJsonMarshaller instance;

    public void marshall(Trace trace, StructuredJsonGenerator jsonGenerator) {
        if (trace == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Segment> segmentsList;
            jsonGenerator.writeStartObject();
            if (trace.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(trace.getId());
            }
            if (trace.getDuration() != null) {
                jsonGenerator.writeFieldName("Duration").writeValue(trace.getDuration());
            }
            if ((segmentsList = trace.getSegments()) != null) {
                jsonGenerator.writeFieldName("Segments");
                jsonGenerator.writeStartArray();
                for (Segment segmentsListValue : segmentsList) {
                    if (segmentsListValue == null) continue;
                    SegmentJsonMarshaller.getInstance().marshall(segmentsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TraceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TraceJsonMarshaller();
        }
        return instance;
    }
}

