/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.ListClusterJobsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListClusterJobsRequestMarshaller
implements Marshaller<Request<ListClusterJobsRequest>, ListClusterJobsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListClusterJobsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListClusterJobsRequest> marshall(ListClusterJobsRequest listClusterJobsRequest) {
        if (listClusterJobsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListClusterJobsRequest> request = new DefaultRequest<ListClusterJobsRequest>(listClusterJobsRequest, "AmazonSnowball");
        request.addHeader("X-Amz-Target", "AWSIESnowballJobManagementService.ListClusterJobs");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listClusterJobsRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(listClusterJobsRequest.getClusterId());
            }
            if (listClusterJobsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listClusterJobsRequest.getMaxResults());
            }
            if (listClusterJobsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listClusterJobsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

