/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.EventTriggerDefinition;
import com.amazonaws.services.snowball.model.LambdaResource;
import com.amazonaws.services.snowball.model.transform.EventTriggerDefinitionJsonMarshaller;
import java.util.List;

public class LambdaResourceJsonMarshaller {
    private static LambdaResourceJsonMarshaller instance;

    public void marshall(LambdaResource lambdaResource, StructuredJsonGenerator jsonGenerator) {
        if (lambdaResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<EventTriggerDefinition> eventTriggersList;
            jsonGenerator.writeStartObject();
            if (lambdaResource.getLambdaArn() != null) {
                jsonGenerator.writeFieldName("LambdaArn").writeValue(lambdaResource.getLambdaArn());
            }
            if ((eventTriggersList = lambdaResource.getEventTriggers()) != null) {
                jsonGenerator.writeFieldName("EventTriggers");
                jsonGenerator.writeStartArray();
                for (EventTriggerDefinition eventTriggersListValue : eventTriggersList) {
                    if (eventTriggersListValue == null) continue;
                    EventTriggerDefinitionJsonMarshaller.getInstance().marshall(eventTriggersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LambdaResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LambdaResourceJsonMarshaller();
        }
        return instance;
    }
}

