/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworkscm.model.CreateServerRequest;
import com.amazonaws.services.opsworkscm.model.EngineAttribute;
import com.amazonaws.services.opsworkscm.model.transform.EngineAttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateServerRequestMarshaller
implements Marshaller<Request<CreateServerRequest>, CreateServerRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateServerRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateServerRequest> marshall(CreateServerRequest createServerRequest) {
        if (createServerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateServerRequest> request = new DefaultRequest<CreateServerRequest>(createServerRequest, "AWSOpsWorksCM");
        request.addHeader("X-Amz-Target", "OpsWorksCM_V2016_11_01.CreateServer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> list;
            List<String> securityGroupIdsList;
            List<EngineAttribute> engineAttributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createServerRequest.getDisableAutomatedBackup() != null) {
                jsonGenerator.writeFieldName("DisableAutomatedBackup").writeValue(createServerRequest.getDisableAutomatedBackup());
            }
            if (createServerRequest.getEngine() != null) {
                jsonGenerator.writeFieldName("Engine").writeValue(createServerRequest.getEngine());
            }
            if (createServerRequest.getEngineModel() != null) {
                jsonGenerator.writeFieldName("EngineModel").writeValue(createServerRequest.getEngineModel());
            }
            if (createServerRequest.getEngineVersion() != null) {
                jsonGenerator.writeFieldName("EngineVersion").writeValue(createServerRequest.getEngineVersion());
            }
            if ((engineAttributesList = createServerRequest.getEngineAttributes()) != null) {
                jsonGenerator.writeFieldName("EngineAttributes");
                jsonGenerator.writeStartArray();
                for (EngineAttribute engineAttribute : engineAttributesList) {
                    if (engineAttribute == null) continue;
                    EngineAttributeJsonMarshaller.getInstance().marshall(engineAttribute, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createServerRequest.getBackupRetentionCount() != null) {
                jsonGenerator.writeFieldName("BackupRetentionCount").writeValue(createServerRequest.getBackupRetentionCount());
            }
            if (createServerRequest.getServerName() != null) {
                jsonGenerator.writeFieldName("ServerName").writeValue(createServerRequest.getServerName());
            }
            if (createServerRequest.getInstanceProfileArn() != null) {
                jsonGenerator.writeFieldName("InstanceProfileArn").writeValue(createServerRequest.getInstanceProfileArn());
            }
            if (createServerRequest.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(createServerRequest.getInstanceType());
            }
            if (createServerRequest.getKeyPair() != null) {
                jsonGenerator.writeFieldName("KeyPair").writeValue(createServerRequest.getKeyPair());
            }
            if (createServerRequest.getPreferredMaintenanceWindow() != null) {
                jsonGenerator.writeFieldName("PreferredMaintenanceWindow").writeValue(createServerRequest.getPreferredMaintenanceWindow());
            }
            if (createServerRequest.getPreferredBackupWindow() != null) {
                jsonGenerator.writeFieldName("PreferredBackupWindow").writeValue(createServerRequest.getPreferredBackupWindow());
            }
            if ((securityGroupIdsList = createServerRequest.getSecurityGroupIds()) != null) {
                jsonGenerator.writeFieldName("SecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (String string : securityGroupIdsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if (createServerRequest.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("ServiceRoleArn").writeValue(createServerRequest.getServiceRoleArn());
            }
            if ((list = createServerRequest.getSubnetIds()) != null) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : list) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createServerRequest.getBackupId() != null) {
                jsonGenerator.writeFieldName("BackupId").writeValue(createServerRequest.getBackupId());
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

