/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.GrantAccessRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GrantAccessRequestMarshaller
implements Marshaller<Request<GrantAccessRequest>, GrantAccessRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GrantAccessRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GrantAccessRequest> marshall(GrantAccessRequest grantAccessRequest) {
        if (grantAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GrantAccessRequest> request = new DefaultRequest<GrantAccessRequest>(grantAccessRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.GrantAccess");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (grantAccessRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(grantAccessRequest.getInstanceId());
            }
            if (grantAccessRequest.getValidForInMinutes() != null) {
                jsonGenerator.writeFieldName("ValidForInMinutes").writeValue(grantAccessRequest.getValidForInMinutes());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

