/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.machinelearning.model.CreateEvaluationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateEvaluationRequestMarshaller
implements Marshaller<Request<CreateEvaluationRequest>, CreateEvaluationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateEvaluationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateEvaluationRequest> marshall(CreateEvaluationRequest createEvaluationRequest) {
        if (createEvaluationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateEvaluationRequest> request = new DefaultRequest<CreateEvaluationRequest>(createEvaluationRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.CreateEvaluation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createEvaluationRequest.getEvaluationId() != null) {
                jsonGenerator.writeFieldName("EvaluationId").writeValue(createEvaluationRequest.getEvaluationId());
            }
            if (createEvaluationRequest.getEvaluationName() != null) {
                jsonGenerator.writeFieldName("EvaluationName").writeValue(createEvaluationRequest.getEvaluationName());
            }
            if (createEvaluationRequest.getMLModelId() != null) {
                jsonGenerator.writeFieldName("MLModelId").writeValue(createEvaluationRequest.getMLModelId());
            }
            if (createEvaluationRequest.getEvaluationDataSourceId() != null) {
                jsonGenerator.writeFieldName("EvaluationDataSourceId").writeValue(createEvaluationRequest.getEvaluationDataSourceId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

