/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.PutKeyPolicyRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PutKeyPolicyRequestMarshaller
implements Marshaller<Request<PutKeyPolicyRequest>, PutKeyPolicyRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutKeyPolicyRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutKeyPolicyRequest> marshall(PutKeyPolicyRequest putKeyPolicyRequest) {
        if (putKeyPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutKeyPolicyRequest> request = new DefaultRequest<PutKeyPolicyRequest>(putKeyPolicyRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.PutKeyPolicy");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putKeyPolicyRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(putKeyPolicyRequest.getKeyId());
            }
            if (putKeyPolicyRequest.getPolicyName() != null) {
                jsonGenerator.writeFieldName("PolicyName").writeValue(putKeyPolicyRequest.getPolicyName());
            }
            if (putKeyPolicyRequest.getPolicy() != null) {
                jsonGenerator.writeFieldName("Policy").writeValue(putKeyPolicyRequest.getPolicy());
            }
            if (putKeyPolicyRequest.getBypassPolicyLockoutSafetyCheck() != null) {
                jsonGenerator.writeFieldName("BypassPolicyLockoutSafetyCheck").writeValue(putKeyPolicyRequest.getBypassPolicyLockoutSafetyCheck());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

