/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.health.model.EventTypeFilter;
import java.util.List;

public class EventTypeFilterJsonMarshaller {
    private static EventTypeFilterJsonMarshaller instance;

    public void marshall(EventTypeFilter eventTypeFilter, StructuredJsonGenerator jsonGenerator) {
        if (eventTypeFilter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> list;
            List<String> servicesList;
            jsonGenerator.writeStartObject();
            List<String> eventTypeCodesList = eventTypeFilter.getEventTypeCodes();
            if (eventTypeCodesList != null) {
                jsonGenerator.writeFieldName("eventTypeCodes");
                jsonGenerator.writeStartArray();
                for (String string : eventTypeCodesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((servicesList = eventTypeFilter.getServices()) != null) {
                jsonGenerator.writeFieldName("services");
                jsonGenerator.writeStartArray();
                for (String servicesListValue : servicesList) {
                    if (servicesListValue == null) continue;
                    jsonGenerator.writeValue(servicesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = eventTypeFilter.getEventTypeCategories()) != null) {
                jsonGenerator.writeFieldName("eventTypeCategories");
                jsonGenerator.writeStartArray();
                for (String eventTypeCategoriesListValue : list) {
                    if (eventTypeCategoriesListValue == null) continue;
                    jsonGenerator.writeValue(eventTypeCategoriesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EventTypeFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EventTypeFilterJsonMarshaller();
        }
        return instance;
    }
}

